# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAwsUnityCatalogAssumeRolePolicyResult',
    'AwaitableGetAwsUnityCatalogAssumeRolePolicyResult',
    'get_aws_unity_catalog_assume_role_policy',
    'get_aws_unity_catalog_assume_role_policy_output',
]

@pulumi.output_type
class GetAwsUnityCatalogAssumeRolePolicyResult:
    """
    A collection of values returned by getAwsUnityCatalogAssumeRolePolicy.
    """
    def __init__(__self__, aws_account_id=None, aws_partition=None, external_id=None, id=None, json=None, role_name=None, unity_catalog_iam_arn=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_partition and not isinstance(aws_partition, str):
            raise TypeError("Expected argument 'aws_partition' to be a str")
        pulumi.set(__self__, "aws_partition", aws_partition)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)
        if unity_catalog_iam_arn and not isinstance(unity_catalog_iam_arn, str):
            raise TypeError("Expected argument 'unity_catalog_iam_arn' to be a str")
        pulumi.set(__self__, "unity_catalog_iam_arn", unity_catalog_iam_arn)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> _builtins.str:
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="awsPartition")
    def aws_partition(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "aws_partition")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def json(self) -> _builtins.str:
        """
        AWS IAM Policy JSON document for assume role
        """
        return pulumi.get(self, "json")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="unityCatalogIamArn")
    def unity_catalog_iam_arn(self) -> _builtins.str:
        return pulumi.get(self, "unity_catalog_iam_arn")


class AwaitableGetAwsUnityCatalogAssumeRolePolicyResult(GetAwsUnityCatalogAssumeRolePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsUnityCatalogAssumeRolePolicyResult(
            aws_account_id=self.aws_account_id,
            aws_partition=self.aws_partition,
            external_id=self.external_id,
            id=self.id,
            json=self.json,
            role_name=self.role_name,
            unity_catalog_iam_arn=self.unity_catalog_iam_arn)


def get_aws_unity_catalog_assume_role_policy(aws_account_id: Optional[_builtins.str] = None,
                                             aws_partition: Optional[_builtins.str] = None,
                                             external_id: Optional[_builtins.str] = None,
                                             role_name: Optional[_builtins.str] = None,
                                             unity_catalog_iam_arn: Optional[_builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsUnityCatalogAssumeRolePolicyResult:
    """
    This data source constructs the necessary AWS Unity Catalog assume role policy for you.

    > This data source can be used with an account or workspace-level provider.

    > This data source has an evolving API, which may change in future versions of the provider. Please always consult [latest documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws) in case of any questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this = databricks.get_aws_unity_catalog_policy(aws_account_id=aws_account_id,
        bucket_name="databricks-bucket",
        role_name=f"{prefix}-uc-access",
        kms_name="arn:aws:kms:us-west-2:111122223333:key/databricks-kms")
    this_get_aws_unity_catalog_assume_role_policy = databricks.get_aws_unity_catalog_assume_role_policy(aws_account_id=aws_account_id,
        role_name=f"{prefix}-uc-access",
        external_id="12345")
    unity_metastore = aws.iam.Policy("unity_metastore",
        name=f"{prefix}-unity-catalog-metastore-access-iam-policy",
        policy=this.json)
    metastore_data_access = aws.iam.Role("metastore_data_access",
        name=f"{prefix}-uc-access",
        assume_role_policy=this_get_aws_unity_catalog_assume_role_policy.json)
    metastore_data_access_role_policy_attachment = aws.iam.RolePolicyAttachment("metastore_data_access",
        role=metastore_data_access.name,
        policy_arn=unity_metastore.arn)
    ```


    :param _builtins.str aws_account_id: The Account ID of the current AWS account (not your Databricks account).
    :param _builtins.str aws_partition: AWS partition. The options are `aws`,`aws-us-gov` or `aws-us-gov-dod`. Defaults to `aws`
    :param _builtins.str external_id: The storage credential external id.
    :param _builtins.str role_name: The name of the AWS IAM role to be created for Unity Catalog.
    :param _builtins.str unity_catalog_iam_arn: The Databricks Unity Catalog IAM Role ARN. Defaults to `arn:aws:iam::414351767826:role/unity-catalog-prod-UCMasterRole-14S5ZJVKOTYTL` on standard AWS partition selection, `arn:aws-us-gov:iam::044793339203:role/unity-catalog-prod-UCMasterRole-1QRFA8SGY15OJ` on GovCloud partition selection, and `arn:aws-us-gov:iam::170661010020:role/unity-catalog-prod-UCMasterRole-1DI6DL6ZP26AS` on GovCloud DoD partition selection
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['awsPartition'] = aws_partition
    __args__['externalId'] = external_id
    __args__['roleName'] = role_name
    __args__['unityCatalogIamArn'] = unity_catalog_iam_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getAwsUnityCatalogAssumeRolePolicy:getAwsUnityCatalogAssumeRolePolicy', __args__, opts=opts, typ=GetAwsUnityCatalogAssumeRolePolicyResult).value

    return AwaitableGetAwsUnityCatalogAssumeRolePolicyResult(
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        aws_partition=pulumi.get(__ret__, 'aws_partition'),
        external_id=pulumi.get(__ret__, 'external_id'),
        id=pulumi.get(__ret__, 'id'),
        json=pulumi.get(__ret__, 'json'),
        role_name=pulumi.get(__ret__, 'role_name'),
        unity_catalog_iam_arn=pulumi.get(__ret__, 'unity_catalog_iam_arn'))
def get_aws_unity_catalog_assume_role_policy_output(aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                    aws_partition: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    external_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                    role_name: Optional[pulumi.Input[_builtins.str]] = None,
                                                    unity_catalog_iam_arn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsUnityCatalogAssumeRolePolicyResult]:
    """
    This data source constructs the necessary AWS Unity Catalog assume role policy for you.

    > This data source can be used with an account or workspace-level provider.

    > This data source has an evolving API, which may change in future versions of the provider. Please always consult [latest documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws) in case of any questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this = databricks.get_aws_unity_catalog_policy(aws_account_id=aws_account_id,
        bucket_name="databricks-bucket",
        role_name=f"{prefix}-uc-access",
        kms_name="arn:aws:kms:us-west-2:111122223333:key/databricks-kms")
    this_get_aws_unity_catalog_assume_role_policy = databricks.get_aws_unity_catalog_assume_role_policy(aws_account_id=aws_account_id,
        role_name=f"{prefix}-uc-access",
        external_id="12345")
    unity_metastore = aws.iam.Policy("unity_metastore",
        name=f"{prefix}-unity-catalog-metastore-access-iam-policy",
        policy=this.json)
    metastore_data_access = aws.iam.Role("metastore_data_access",
        name=f"{prefix}-uc-access",
        assume_role_policy=this_get_aws_unity_catalog_assume_role_policy.json)
    metastore_data_access_role_policy_attachment = aws.iam.RolePolicyAttachment("metastore_data_access",
        role=metastore_data_access.name,
        policy_arn=unity_metastore.arn)
    ```


    :param _builtins.str aws_account_id: The Account ID of the current AWS account (not your Databricks account).
    :param _builtins.str aws_partition: AWS partition. The options are `aws`,`aws-us-gov` or `aws-us-gov-dod`. Defaults to `aws`
    :param _builtins.str external_id: The storage credential external id.
    :param _builtins.str role_name: The name of the AWS IAM role to be created for Unity Catalog.
    :param _builtins.str unity_catalog_iam_arn: The Databricks Unity Catalog IAM Role ARN. Defaults to `arn:aws:iam::414351767826:role/unity-catalog-prod-UCMasterRole-14S5ZJVKOTYTL` on standard AWS partition selection, `arn:aws-us-gov:iam::044793339203:role/unity-catalog-prod-UCMasterRole-1QRFA8SGY15OJ` on GovCloud partition selection, and `arn:aws-us-gov:iam::170661010020:role/unity-catalog-prod-UCMasterRole-1DI6DL6ZP26AS` on GovCloud DoD partition selection
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['awsPartition'] = aws_partition
    __args__['externalId'] = external_id
    __args__['roleName'] = role_name
    __args__['unityCatalogIamArn'] = unity_catalog_iam_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getAwsUnityCatalogAssumeRolePolicy:getAwsUnityCatalogAssumeRolePolicy', __args__, opts=opts, typ=GetAwsUnityCatalogAssumeRolePolicyResult)
    return __ret__.apply(lambda __response__: GetAwsUnityCatalogAssumeRolePolicyResult(
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        aws_partition=pulumi.get(__response__, 'aws_partition'),
        external_id=pulumi.get(__response__, 'external_id'),
        id=pulumi.get(__response__, 'id'),
        json=pulumi.get(__response__, 'json'),
        role_name=pulumi.get(__response__, 'role_name'),
        unity_catalog_iam_arn=pulumi.get(__response__, 'unity_catalog_iam_arn')))
