# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCleanRoomAutoApprovalRuleResult',
    'AwaitableGetCleanRoomAutoApprovalRuleResult',
    'get_clean_room_auto_approval_rule',
    'get_clean_room_auto_approval_rule_output',
]

@pulumi.output_type
class GetCleanRoomAutoApprovalRuleResult:
    """
    A collection of values returned by getCleanRoomAutoApprovalRule.
    """
    def __init__(__self__, author_collaborator_alias=None, author_scope=None, clean_room_name=None, created_at=None, id=None, rule_id=None, rule_owner_collaborator_alias=None, runner_collaborator_alias=None, workspace_id=None):
        if author_collaborator_alias and not isinstance(author_collaborator_alias, str):
            raise TypeError("Expected argument 'author_collaborator_alias' to be a str")
        pulumi.set(__self__, "author_collaborator_alias", author_collaborator_alias)
        if author_scope and not isinstance(author_scope, str):
            raise TypeError("Expected argument 'author_scope' to be a str")
        pulumi.set(__self__, "author_scope", author_scope)
        if clean_room_name and not isinstance(clean_room_name, str):
            raise TypeError("Expected argument 'clean_room_name' to be a str")
        pulumi.set(__self__, "clean_room_name", clean_room_name)
        if created_at and not isinstance(created_at, int):
            raise TypeError("Expected argument 'created_at' to be a int")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if rule_owner_collaborator_alias and not isinstance(rule_owner_collaborator_alias, str):
            raise TypeError("Expected argument 'rule_owner_collaborator_alias' to be a str")
        pulumi.set(__self__, "rule_owner_collaborator_alias", rule_owner_collaborator_alias)
        if runner_collaborator_alias and not isinstance(runner_collaborator_alias, str):
            raise TypeError("Expected argument 'runner_collaborator_alias' to be a str")
        pulumi.set(__self__, "runner_collaborator_alias", runner_collaborator_alias)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="authorCollaboratorAlias")
    def author_collaborator_alias(self) -> Optional[_builtins.str]:
        """
        (string) - Collaborator alias of the author covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set
        """
        return pulumi.get(self, "author_collaborator_alias")

    @_builtins.property
    @pulumi.getter(name="authorScope")
    def author_scope(self) -> Optional[_builtins.str]:
        """
        (string) - Scope of authors covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        """
        return pulumi.get(self, "author_scope")

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> Optional[_builtins.str]:
        """
        (string) - The name of the clean room this auto-approval rule belongs to
        """
        return pulumi.get(self, "clean_room_name")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.int:
        """
        (integer) - Timestamp of when the rule was created, in epoch milliseconds
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.str:
        """
        (string) - A generated UUID identifying the rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleOwnerCollaboratorAlias")
    def rule_owner_collaborator_alias(self) -> _builtins.str:
        """
        (string) - The owner of the rule to whom the rule applies
        """
        return pulumi.get(self, "rule_owner_collaborator_alias")

    @_builtins.property
    @pulumi.getter(name="runnerCollaboratorAlias")
    def runner_collaborator_alias(self) -> Optional[_builtins.str]:
        """
        (string) - Collaborator alias of the runner covered by the rule
        """
        return pulumi.get(self, "runner_collaborator_alias")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetCleanRoomAutoApprovalRuleResult(GetCleanRoomAutoApprovalRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCleanRoomAutoApprovalRuleResult(
            author_collaborator_alias=self.author_collaborator_alias,
            author_scope=self.author_scope,
            clean_room_name=self.clean_room_name,
            created_at=self.created_at,
            id=self.id,
            rule_id=self.rule_id,
            rule_owner_collaborator_alias=self.rule_owner_collaborator_alias,
            runner_collaborator_alias=self.runner_collaborator_alias,
            workspace_id=self.workspace_id)


def get_clean_room_auto_approval_rule(author_collaborator_alias: Optional[_builtins.str] = None,
                                      author_scope: Optional[_builtins.str] = None,
                                      clean_room_name: Optional[_builtins.str] = None,
                                      runner_collaborator_alias: Optional[_builtins.str] = None,
                                      workspace_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCleanRoomAutoApprovalRuleResult:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str author_collaborator_alias: (string) - Collaborator alias of the author covered by the rule.
           Only one of `author_collaborator_alias` and `author_scope` can be set
    :param _builtins.str author_scope: (string) - Scope of authors covered by the rule.
           Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
    :param _builtins.str clean_room_name: (string) - The name of the clean room this auto-approval rule belongs to
    :param _builtins.str runner_collaborator_alias: (string) - Collaborator alias of the runner covered by the rule
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['authorCollaboratorAlias'] = author_collaborator_alias
    __args__['authorScope'] = author_scope
    __args__['cleanRoomName'] = clean_room_name
    __args__['runnerCollaboratorAlias'] = runner_collaborator_alias
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCleanRoomAutoApprovalRule:getCleanRoomAutoApprovalRule', __args__, opts=opts, typ=GetCleanRoomAutoApprovalRuleResult).value

    return AwaitableGetCleanRoomAutoApprovalRuleResult(
        author_collaborator_alias=pulumi.get(__ret__, 'author_collaborator_alias'),
        author_scope=pulumi.get(__ret__, 'author_scope'),
        clean_room_name=pulumi.get(__ret__, 'clean_room_name'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        rule_owner_collaborator_alias=pulumi.get(__ret__, 'rule_owner_collaborator_alias'),
        runner_collaborator_alias=pulumi.get(__ret__, 'runner_collaborator_alias'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_clean_room_auto_approval_rule_output(author_collaborator_alias: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             author_scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             clean_room_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             runner_collaborator_alias: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCleanRoomAutoApprovalRuleResult]:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str author_collaborator_alias: (string) - Collaborator alias of the author covered by the rule.
           Only one of `author_collaborator_alias` and `author_scope` can be set
    :param _builtins.str author_scope: (string) - Scope of authors covered by the rule.
           Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
    :param _builtins.str clean_room_name: (string) - The name of the clean room this auto-approval rule belongs to
    :param _builtins.str runner_collaborator_alias: (string) - Collaborator alias of the runner covered by the rule
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['authorCollaboratorAlias'] = author_collaborator_alias
    __args__['authorScope'] = author_scope
    __args__['cleanRoomName'] = clean_room_name
    __args__['runnerCollaboratorAlias'] = runner_collaborator_alias
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getCleanRoomAutoApprovalRule:getCleanRoomAutoApprovalRule', __args__, opts=opts, typ=GetCleanRoomAutoApprovalRuleResult)
    return __ret__.apply(lambda __response__: GetCleanRoomAutoApprovalRuleResult(
        author_collaborator_alias=pulumi.get(__response__, 'author_collaborator_alias'),
        author_scope=pulumi.get(__response__, 'author_scope'),
        clean_room_name=pulumi.get(__response__, 'clean_room_name'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        rule_owner_collaborator_alias=pulumi.get(__response__, 'rule_owner_collaborator_alias'),
        runner_collaborator_alias=pulumi.get(__response__, 'runner_collaborator_alias'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
