# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, cluster_name_contains=None, filter_by=None, id=None, ids=None):
        if cluster_name_contains and not isinstance(cluster_name_contains, str):
            raise TypeError("Expected argument 'cluster_name_contains' to be a str")
        pulumi.set(__self__, "cluster_name_contains", cluster_name_contains)
        if filter_by and not isinstance(filter_by, dict):
            raise TypeError("Expected argument 'filter_by' to be a dict")
        pulumi.set(__self__, "filter_by", filter_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)

    @_builtins.property
    @pulumi.getter(name="clusterNameContains")
    def cluster_name_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cluster_name_contains")

    @_builtins.property
    @pulumi.getter(name="filterBy")
    def filter_by(self) -> Optional['outputs.GetClustersFilterByResult']:
        return pulumi.get(self, "filter_by")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        list of Cluster ids
        """
        return pulumi.get(self, "ids")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            cluster_name_contains=self.cluster_name_contains,
            filter_by=self.filter_by,
            id=self.id,
            ids=self.ids)


def get_clusters(cluster_name_contains: Optional[_builtins.str] = None,
                 filter_by: Optional[Union['GetClustersFilterByArgs', 'GetClustersFilterByArgsDict']] = None,
                 id: Optional[_builtins.str] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    Retrieves a list of Cluster ids, that were created by Pulumi or manually, with or without databricks_cluster_policy.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Retrieve cluster IDs for all clusters:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_clusters()
    ```

    Retrieve cluster IDs for all clusters having "Shared" in the cluster name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all_shared = databricks.get_clusters(cluster_name_contains="shared")
    ```

    ### Filtering clusters

    Listing clusters can be slow for workspaces containing many clusters. Use filters to limit the number of clusters returned for better performance. You can filter clusters by state, source, policy, or pinned status:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all_running_clusters = databricks.get_clusters(filter_by={
        "cluster_states": ["RUNNING"],
    })
    all_clusters_with_policy = databricks.get_clusters(filter_by={
        "policy_id": "1234-5678-9012",
    })
    all_api_clusters = databricks.get_clusters(filter_by={
        "cluster_sources": ["API"],
    })
    all_pinned_clusters = databricks.get_clusters(filter_by={
        "is_pinned": True,
    })
    ```

    ## Related Resources

    The following resources are used in the same context:

    * End to end workspace management guide.
    * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
    * ClusterPolicy to create a Cluster policy, which limits the ability to create clusters based on a set of rules.
    * InstancePool to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.
    * Library to install a [library](https://docs.databricks.com/libraries/index.html) on databricks_cluster.
    * Pipeline to deploy [Lakeflow Declarative Pipelines](https://docs.databricks.com/aws/en/dlt).


    :param _builtins.str cluster_name_contains: Only return Cluster ids that match the given name string.
    :param Union['GetClustersFilterByArgs', 'GetClustersFilterByArgsDict'] filter_by: Filters to apply to the listed clusters. See filter_by Configuration Block below for details.
    :param Sequence[_builtins.str] ids: list of Cluster ids
    """
    __args__ = dict()
    __args__['clusterNameContains'] = cluster_name_contains
    __args__['filterBy'] = filter_by
    __args__['id'] = id
    __args__['ids'] = ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        cluster_name_contains=pulumi.get(__ret__, 'cluster_name_contains'),
        filter_by=pulumi.get(__ret__, 'filter_by'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'))
def get_clusters_output(cluster_name_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        filter_by: Optional[pulumi.Input[Optional[Union['GetClustersFilterByArgs', 'GetClustersFilterByArgsDict']]]] = None,
                        id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClustersResult]:
    """
    Retrieves a list of Cluster ids, that were created by Pulumi or manually, with or without databricks_cluster_policy.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Retrieve cluster IDs for all clusters:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_clusters()
    ```

    Retrieve cluster IDs for all clusters having "Shared" in the cluster name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all_shared = databricks.get_clusters(cluster_name_contains="shared")
    ```

    ### Filtering clusters

    Listing clusters can be slow for workspaces containing many clusters. Use filters to limit the number of clusters returned for better performance. You can filter clusters by state, source, policy, or pinned status:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all_running_clusters = databricks.get_clusters(filter_by={
        "cluster_states": ["RUNNING"],
    })
    all_clusters_with_policy = databricks.get_clusters(filter_by={
        "policy_id": "1234-5678-9012",
    })
    all_api_clusters = databricks.get_clusters(filter_by={
        "cluster_sources": ["API"],
    })
    all_pinned_clusters = databricks.get_clusters(filter_by={
        "is_pinned": True,
    })
    ```

    ## Related Resources

    The following resources are used in the same context:

    * End to end workspace management guide.
    * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
    * ClusterPolicy to create a Cluster policy, which limits the ability to create clusters based on a set of rules.
    * InstancePool to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.
    * Library to install a [library](https://docs.databricks.com/libraries/index.html) on databricks_cluster.
    * Pipeline to deploy [Lakeflow Declarative Pipelines](https://docs.databricks.com/aws/en/dlt).


    :param _builtins.str cluster_name_contains: Only return Cluster ids that match the given name string.
    :param Union['GetClustersFilterByArgs', 'GetClustersFilterByArgsDict'] filter_by: Filters to apply to the listed clusters. See filter_by Configuration Block below for details.
    :param Sequence[_builtins.str] ids: list of Cluster ids
    """
    __args__ = dict()
    __args__['clusterNameContains'] = cluster_name_contains
    __args__['filterBy'] = filter_by
    __args__['id'] = id
    __args__['ids'] = ids
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult)
    return __ret__.apply(lambda __response__: GetClustersResult(
        cluster_name_contains=pulumi.get(__response__, 'cluster_name_contains'),
        filter_by=pulumi.get(__response__, 'filter_by'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids')))
