# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetExternalMetadataResult',
    'AwaitableGetExternalMetadataResult',
    'get_external_metadata',
    'get_external_metadata_output',
]

@pulumi.output_type
class GetExternalMetadataResult:
    """
    A collection of values returned by getExternalMetadata.
    """
    def __init__(__self__, columns=None, create_time=None, created_by=None, description=None, entity_type=None, id=None, metastore_id=None, name=None, owner=None, properties=None, system_type=None, update_time=None, updated_by=None, url=None, workspace_id=None):
        if columns and not isinstance(columns, list):
            raise TypeError("Expected argument 'columns' to be a list")
        pulumi.set(__self__, "columns", columns)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metastore_id and not isinstance(metastore_id, str):
            raise TypeError("Expected argument 'metastore_id' to be a str")
        pulumi.set(__self__, "metastore_id", metastore_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if system_type and not isinstance(system_type, str):
            raise TypeError("Expected argument 'system_type' to be a str")
        pulumi.set(__self__, "system_type", system_type)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if updated_by and not isinstance(updated_by, str):
            raise TypeError("Expected argument 'updated_by' to be a str")
        pulumi.set(__self__, "updated_by", updated_by)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[_builtins.str]]:
        """
        (list of string) - List of columns associated with the external metadata object
        """
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        (string) - Time at which this external metadata object was created
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        (string) - Username of external metadata object creator
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (string) - User-provided free-form text description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        (string) - Type of entity within the external system
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (string) - Unique identifier of the external metadata object
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> _builtins.str:
        """
        (string) - Unique identifier of parent metastore
        """
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (string) - Name of the external metadata object
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[_builtins.str]:
        """
        (string) - Owner of the external metadata object
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (object) - A map of key-value properties attached to the external metadata object
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> _builtins.str:
        """
        (string) - Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        """
        return pulumi.get(self, "system_type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        (string) - Time at which this external metadata object was last modified
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        (string) - Username of user who last modified external metadata object
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (string) - URL associated with the external metadata object
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetExternalMetadataResult(GetExternalMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalMetadataResult(
            columns=self.columns,
            create_time=self.create_time,
            created_by=self.created_by,
            description=self.description,
            entity_type=self.entity_type,
            id=self.id,
            metastore_id=self.metastore_id,
            name=self.name,
            owner=self.owner,
            properties=self.properties,
            system_type=self.system_type,
            update_time=self.update_time,
            updated_by=self.updated_by,
            url=self.url,
            workspace_id=self.workspace_id)


def get_external_metadata(columns: Optional[Sequence[_builtins.str]] = None,
                          description: Optional[_builtins.str] = None,
                          entity_type: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          owner: Optional[_builtins.str] = None,
                          properties: Optional[Mapping[str, _builtins.str]] = None,
                          system_type: Optional[_builtins.str] = None,
                          url: Optional[_builtins.str] = None,
                          workspace_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalMetadataResult:
    """
    This data source can be used to get a single external metadata object.

    > **Note** This resource can only be used with an workspace-level provider!

    ## Example Usage

    Referring to an external metadata object by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_external_metadata(name="security_events_stream")
    ```


    :param Sequence[_builtins.str] columns: (list of string) - List of columns associated with the external metadata object
    :param _builtins.str description: (string) - User-provided free-form text description
    :param _builtins.str entity_type: (string) - Type of entity within the external system
    :param _builtins.str name: Name of the external metadata object
    :param _builtins.str owner: (string) - Owner of the external metadata object
    :param Mapping[str, _builtins.str] properties: (object) - A map of key-value properties attached to the external metadata object
    :param _builtins.str system_type: (string) - Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
    :param _builtins.str url: (string) - URL associated with the external metadata object
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['columns'] = columns
    __args__['description'] = description
    __args__['entityType'] = entity_type
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['properties'] = properties
    __args__['systemType'] = system_type
    __args__['url'] = url
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getExternalMetadata:getExternalMetadata', __args__, opts=opts, typ=GetExternalMetadataResult).value

    return AwaitableGetExternalMetadataResult(
        columns=pulumi.get(__ret__, 'columns'),
        create_time=pulumi.get(__ret__, 'create_time'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        id=pulumi.get(__ret__, 'id'),
        metastore_id=pulumi.get(__ret__, 'metastore_id'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        properties=pulumi.get(__ret__, 'properties'),
        system_type=pulumi.get(__ret__, 'system_type'),
        update_time=pulumi.get(__ret__, 'update_time'),
        updated_by=pulumi.get(__ret__, 'updated_by'),
        url=pulumi.get(__ret__, 'url'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_external_metadata_output(columns: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                                 name: Optional[pulumi.Input[_builtins.str]] = None,
                                 owner: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 properties: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                                 url: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalMetadataResult]:
    """
    This data source can be used to get a single external metadata object.

    > **Note** This resource can only be used with an workspace-level provider!

    ## Example Usage

    Referring to an external metadata object by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_external_metadata(name="security_events_stream")
    ```


    :param Sequence[_builtins.str] columns: (list of string) - List of columns associated with the external metadata object
    :param _builtins.str description: (string) - User-provided free-form text description
    :param _builtins.str entity_type: (string) - Type of entity within the external system
    :param _builtins.str name: Name of the external metadata object
    :param _builtins.str owner: (string) - Owner of the external metadata object
    :param Mapping[str, _builtins.str] properties: (object) - A map of key-value properties attached to the external metadata object
    :param _builtins.str system_type: (string) - Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
    :param _builtins.str url: (string) - URL associated with the external metadata object
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['columns'] = columns
    __args__['description'] = description
    __args__['entityType'] = entity_type
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['properties'] = properties
    __args__['systemType'] = system_type
    __args__['url'] = url
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getExternalMetadata:getExternalMetadata', __args__, opts=opts, typ=GetExternalMetadataResult)
    return __ret__.apply(lambda __response__: GetExternalMetadataResult(
        columns=pulumi.get(__response__, 'columns'),
        create_time=pulumi.get(__response__, 'create_time'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        id=pulumi.get(__response__, 'id'),
        metastore_id=pulumi.get(__response__, 'metastore_id'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        properties=pulumi.get(__response__, 'properties'),
        system_type=pulumi.get(__response__, 'system_type'),
        update_time=pulumi.get(__response__, 'update_time'),
        updated_by=pulumi.get(__response__, 'updated_by'),
        url=pulumi.get(__response__, 'url'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
