# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetOnlineStoreResult',
    'AwaitableGetOnlineStoreResult',
    'get_online_store',
    'get_online_store_output',
]

@pulumi.output_type
class GetOnlineStoreResult:
    """
    A collection of values returned by getOnlineStore.
    """
    def __init__(__self__, capacity=None, creation_time=None, creator=None, id=None, name=None, read_replica_count=None, state=None, workspace_id=None):
        if capacity and not isinstance(capacity, str):
            raise TypeError("Expected argument 'capacity' to be a str")
        pulumi.set(__self__, "capacity", capacity)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if read_replica_count and not isinstance(read_replica_count, int):
            raise TypeError("Expected argument 'read_replica_count' to be a int")
        pulumi.set(__self__, "read_replica_count", read_replica_count)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.str:
        """
        (string) - The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        (string) - The timestamp when the online store was created
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> _builtins.str:
        """
        (string) - The email of the creator of the online store
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (string) - The name of the online store. This is the unique identifier for the online store
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> Optional[_builtins.int]:
        """
        (integer) - The number of read replicas for the online store. Defaults to 0
        """
        return pulumi.get(self, "read_replica_count")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        (string) - The current state of the online store. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetOnlineStoreResult(GetOnlineStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOnlineStoreResult(
            capacity=self.capacity,
            creation_time=self.creation_time,
            creator=self.creator,
            id=self.id,
            name=self.name,
            read_replica_count=self.read_replica_count,
            state=self.state,
            workspace_id=self.workspace_id)


def get_online_store(capacity: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     read_replica_count: Optional[_builtins.int] = None,
                     workspace_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOnlineStoreResult:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str capacity: (string) - The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
    :param _builtins.str name: The name of the online store. This is the unique identifier for the online store
    :param _builtins.int read_replica_count: (integer) - The number of read replicas for the online store. Defaults to 0
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['capacity'] = capacity
    __args__['name'] = name
    __args__['readReplicaCount'] = read_replica_count
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getOnlineStore:getOnlineStore', __args__, opts=opts, typ=GetOnlineStoreResult).value

    return AwaitableGetOnlineStoreResult(
        capacity=pulumi.get(__ret__, 'capacity'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        creator=pulumi.get(__ret__, 'creator'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        read_replica_count=pulumi.get(__ret__, 'read_replica_count'),
        state=pulumi.get(__ret__, 'state'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_online_store_output(capacity: Optional[pulumi.Input[_builtins.str]] = None,
                            name: Optional[pulumi.Input[_builtins.str]] = None,
                            read_replica_count: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOnlineStoreResult]:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str capacity: (string) - The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
    :param _builtins.str name: The name of the online store. This is the unique identifier for the online store
    :param _builtins.int read_replica_count: (integer) - The number of read replicas for the online store. Defaults to 0
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['capacity'] = capacity
    __args__['name'] = name
    __args__['readReplicaCount'] = read_replica_count
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getOnlineStore:getOnlineStore', __args__, opts=opts, typ=GetOnlineStoreResult)
    return __ret__.apply(lambda __response__: GetOnlineStoreResult(
        capacity=pulumi.get(__response__, 'capacity'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        creator=pulumi.get(__response__, 'creator'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        read_replica_count=pulumi.get(__response__, 'read_replica_count'),
        state=pulumi.get(__response__, 'state'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
