# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetServicePrincipalsResult',
    'AwaitableGetServicePrincipalsResult',
    'get_service_principals',
    'get_service_principals_output',
]

@pulumi.output_type
class GetServicePrincipalsResult:
    """
    A collection of values returned by getServicePrincipals.
    """
    def __init__(__self__, application_ids=None, display_name_contains=None, id=None):
        if application_ids and not isinstance(application_ids, list):
            raise TypeError("Expected argument 'application_ids' to be a list")
        pulumi.set(__self__, "application_ids", application_ids)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="applicationIds")
    def application_ids(self) -> Sequence[_builtins.str]:
        """
        List of `application_ids` of service principals.  Individual service principal can be retrieved using ServicePrincipal data source
        """
        return pulumi.get(self, "application_ids")

    @_builtins.property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> _builtins.str:
        return pulumi.get(self, "display_name_contains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetServicePrincipalsResult(GetServicePrincipalsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicePrincipalsResult(
            application_ids=self.application_ids,
            display_name_contains=self.display_name_contains,
            id=self.id)


def get_service_principals(application_ids: Optional[Sequence[_builtins.str]] = None,
                           display_name_contains: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicePrincipalsResult:
    """
    Retrieves `application_ids` of all ServicePrincipal based on their `display_name`

    > This data source can be used with an account or workspace-level provider.


    :param Sequence[_builtins.str] application_ids: List of `application_ids` of service principals.  Individual service principal can be retrieved using ServicePrincipal data source
    :param _builtins.str display_name_contains: Only return ServicePrincipal display name that match the given name string
    """
    __args__ = dict()
    __args__['applicationIds'] = application_ids
    __args__['displayNameContains'] = display_name_contains
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getServicePrincipals:getServicePrincipals', __args__, opts=opts, typ=GetServicePrincipalsResult).value

    return AwaitableGetServicePrincipalsResult(
        application_ids=pulumi.get(__ret__, 'application_ids'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        id=pulumi.get(__ret__, 'id'))
def get_service_principals_output(application_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  display_name_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServicePrincipalsResult]:
    """
    Retrieves `application_ids` of all ServicePrincipal based on their `display_name`

    > This data source can be used with an account or workspace-level provider.


    :param Sequence[_builtins.str] application_ids: List of `application_ids` of service principals.  Individual service principal can be retrieved using ServicePrincipal data source
    :param _builtins.str display_name_contains: Only return ServicePrincipal display name that match the given name string
    """
    __args__ = dict()
    __args__['applicationIds'] = application_ids
    __args__['displayNameContains'] = display_name_contains
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getServicePrincipals:getServicePrincipals', __args__, opts=opts, typ=GetServicePrincipalsResult)
    return __ret__.apply(lambda __response__: GetServicePrincipalsResult(
        application_ids=pulumi.get(__response__, 'application_ids'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        id=pulumi.get(__response__, 'id')))
