# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyInfoArgs', 'PolicyInfo']

@pulumi.input_type
class PolicyInfoArgs:
    def __init__(__self__, *,
                 for_securable_type: pulumi.Input[_builtins.str],
                 policy_type: pulumi.Input[_builtins.str],
                 to_principals: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 column_mask: Optional[pulumi.Input['PolicyInfoColumnMaskArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 except_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_fullname: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 row_filter: Optional[pulumi.Input['PolicyInfoRowFilterArgs']] = None,
                 when_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyInfo resource.
        :param pulumi.Input[_builtins.str] for_securable_type: Type of securables that the policy should take effect on.
               Only `TABLE` is supported at this moment.
               Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input[_builtins.str] policy_type: Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] to_principals: List of user or group names that the policy applies to.
               Required on create and optional on update
        :param pulumi.Input['PolicyInfoColumnMaskArgs'] column_mask: Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[_builtins.str] comment: Optional description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] except_principals: Optional list of user or group names that should be excluded from the policy
        :param pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]] match_columns: Optional list of condition expressions used to match table columns.
               Only valid when `for_securable_type` is `TABLE`.
               When specified, the policy only applies to tables whose columns satisfy all match conditions
        :param pulumi.Input[_builtins.str] name: Name of the policy. Required on create and optional on update.
               To rename the policy, set `name` to a different value on update
        :param pulumi.Input[_builtins.str] on_securable_fullname: Full name of the securable on which the policy is defined.
               Required on create and ignored on update
        :param pulumi.Input[_builtins.str] on_securable_type: Type of the securable on which the policy is defined.
               Only `CATALOG`, `SCHEMA` and `TABLE` are supported at this moment.
               Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input['PolicyInfoRowFilterArgs'] row_filter: Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[_builtins.str] when_condition: Optional condition when the policy should take effect
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        pulumi.set(__self__, "for_securable_type", for_securable_type)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "to_principals", to_principals)
        if column_mask is not None:
            pulumi.set(__self__, "column_mask", column_mask)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if except_principals is not None:
            pulumi.set(__self__, "except_principals", except_principals)
        if match_columns is not None:
            pulumi.set(__self__, "match_columns", match_columns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_securable_fullname is not None:
            pulumi.set(__self__, "on_securable_fullname", on_securable_fullname)
        if on_securable_type is not None:
            pulumi.set(__self__, "on_securable_type", on_securable_type)
        if row_filter is not None:
            pulumi.set(__self__, "row_filter", row_filter)
        if when_condition is not None:
            pulumi.set(__self__, "when_condition", when_condition)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="forSecurableType")
    def for_securable_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of securables that the policy should take effect on.
        Only `TABLE` is supported at this moment.
        Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "for_securable_type")

    @for_securable_type.setter
    def for_securable_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "for_securable_type", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter(name="toPrincipals")
    def to_principals(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of user or group names that the policy applies to.
        Required on create and optional on update
        """
        return pulumi.get(self, "to_principals")

    @to_principals.setter
    def to_principals(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "to_principals", value)

    @_builtins.property
    @pulumi.getter(name="columnMask")
    def column_mask(self) -> Optional[pulumi.Input['PolicyInfoColumnMaskArgs']]:
        """
        Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "column_mask")

    @column_mask.setter
    def column_mask(self, value: Optional[pulumi.Input['PolicyInfoColumnMaskArgs']]):
        pulumi.set(self, "column_mask", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional description of the policy
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="exceptPrincipals")
    def except_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional list of user or group names that should be excluded from the policy
        """
        return pulumi.get(self, "except_principals")

    @except_principals.setter
    def except_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "except_principals", value)

    @_builtins.property
    @pulumi.getter(name="matchColumns")
    def match_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]]]:
        """
        Optional list of condition expressions used to match table columns.
        Only valid when `for_securable_type` is `TABLE`.
        When specified, the policy only applies to tables whose columns satisfy all match conditions
        """
        return pulumi.get(self, "match_columns")

    @match_columns.setter
    def match_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]]]):
        pulumi.set(self, "match_columns", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the policy. Required on create and optional on update.
        To rename the policy, set `name` to a different value on update
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onSecurableFullname")
    def on_securable_fullname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full name of the securable on which the policy is defined.
        Required on create and ignored on update
        """
        return pulumi.get(self, "on_securable_fullname")

    @on_securable_fullname.setter
    def on_securable_fullname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_securable_fullname", value)

    @_builtins.property
    @pulumi.getter(name="onSecurableType")
    def on_securable_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the securable on which the policy is defined.
        Only `CATALOG`, `SCHEMA` and `TABLE` are supported at this moment.
        Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "on_securable_type")

    @on_securable_type.setter
    def on_securable_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_securable_type", value)

    @_builtins.property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> Optional[pulumi.Input['PolicyInfoRowFilterArgs']]:
        """
        Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "row_filter")

    @row_filter.setter
    def row_filter(self, value: Optional[pulumi.Input['PolicyInfoRowFilterArgs']]):
        pulumi.set(self, "row_filter", value)

    @_builtins.property
    @pulumi.getter(name="whenCondition")
    def when_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional condition when the policy should take effect
        """
        return pulumi.get(self, "when_condition")

    @when_condition.setter
    def when_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "when_condition", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _PolicyInfoState:
    def __init__(__self__, *,
                 column_mask: Optional[pulumi.Input['PolicyInfoColumnMaskArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 except_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 for_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_fullname: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 row_filter: Optional[pulumi.Input['PolicyInfoRowFilterArgs']] = None,
                 to_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 when_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyInfo resources.
        :param pulumi.Input['PolicyInfoColumnMaskArgs'] column_mask: Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[_builtins.str] comment: Optional description of the policy
        :param pulumi.Input[_builtins.int] created_at: (integer) - Time at which the policy was created, in epoch milliseconds. Output only
        :param pulumi.Input[_builtins.str] created_by: (string) - Username of the user who created the policy. Output only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] except_principals: Optional list of user or group names that should be excluded from the policy
        :param pulumi.Input[_builtins.str] for_securable_type: Type of securables that the policy should take effect on.
               Only `TABLE` is supported at this moment.
               Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]] match_columns: Optional list of condition expressions used to match table columns.
               Only valid when `for_securable_type` is `TABLE`.
               When specified, the policy only applies to tables whose columns satisfy all match conditions
        :param pulumi.Input[_builtins.str] name: Name of the policy. Required on create and optional on update.
               To rename the policy, set `name` to a different value on update
        :param pulumi.Input[_builtins.str] on_securable_fullname: Full name of the securable on which the policy is defined.
               Required on create and ignored on update
        :param pulumi.Input[_builtins.str] on_securable_type: Type of the securable on which the policy is defined.
               Only `CATALOG`, `SCHEMA` and `TABLE` are supported at this moment.
               Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input[_builtins.str] policy_type: Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        :param pulumi.Input['PolicyInfoRowFilterArgs'] row_filter: Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] to_principals: List of user or group names that the policy applies to.
               Required on create and optional on update
        :param pulumi.Input[_builtins.int] updated_at: (integer) - Time at which the policy was last modified, in epoch milliseconds. Output only
        :param pulumi.Input[_builtins.str] updated_by: (string) - Username of the user who last modified the policy. Output only
        :param pulumi.Input[_builtins.str] when_condition: Optional condition when the policy should take effect
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if column_mask is not None:
            pulumi.set(__self__, "column_mask", column_mask)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if except_principals is not None:
            pulumi.set(__self__, "except_principals", except_principals)
        if for_securable_type is not None:
            pulumi.set(__self__, "for_securable_type", for_securable_type)
        if match_columns is not None:
            pulumi.set(__self__, "match_columns", match_columns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_securable_fullname is not None:
            pulumi.set(__self__, "on_securable_fullname", on_securable_fullname)
        if on_securable_type is not None:
            pulumi.set(__self__, "on_securable_type", on_securable_type)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if row_filter is not None:
            pulumi.set(__self__, "row_filter", row_filter)
        if to_principals is not None:
            pulumi.set(__self__, "to_principals", to_principals)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)
        if when_condition is not None:
            pulumi.set(__self__, "when_condition", when_condition)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="columnMask")
    def column_mask(self) -> Optional[pulumi.Input['PolicyInfoColumnMaskArgs']]:
        """
        Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "column_mask")

    @column_mask.setter
    def column_mask(self, value: Optional[pulumi.Input['PolicyInfoColumnMaskArgs']]):
        pulumi.set(self, "column_mask", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional description of the policy
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - Time at which the policy was created, in epoch milliseconds. Output only
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Username of the user who created the policy. Output only
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="exceptPrincipals")
    def except_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional list of user or group names that should be excluded from the policy
        """
        return pulumi.get(self, "except_principals")

    @except_principals.setter
    def except_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "except_principals", value)

    @_builtins.property
    @pulumi.getter(name="forSecurableType")
    def for_securable_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of securables that the policy should take effect on.
        Only `TABLE` is supported at this moment.
        Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "for_securable_type")

    @for_securable_type.setter
    def for_securable_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "for_securable_type", value)

    @_builtins.property
    @pulumi.getter(name="matchColumns")
    def match_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]]]:
        """
        Optional list of condition expressions used to match table columns.
        Only valid when `for_securable_type` is `TABLE`.
        When specified, the policy only applies to tables whose columns satisfy all match conditions
        """
        return pulumi.get(self, "match_columns")

    @match_columns.setter
    def match_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyInfoMatchColumnArgs']]]]):
        pulumi.set(self, "match_columns", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the policy. Required on create and optional on update.
        To rename the policy, set `name` to a different value on update
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onSecurableFullname")
    def on_securable_fullname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full name of the securable on which the policy is defined.
        Required on create and ignored on update
        """
        return pulumi.get(self, "on_securable_fullname")

    @on_securable_fullname.setter
    def on_securable_fullname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_securable_fullname", value)

    @_builtins.property
    @pulumi.getter(name="onSecurableType")
    def on_securable_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the securable on which the policy is defined.
        Only `CATALOG`, `SCHEMA` and `TABLE` are supported at this moment.
        Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "on_securable_type")

    @on_securable_type.setter
    def on_securable_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_securable_type", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> Optional[pulumi.Input['PolicyInfoRowFilterArgs']]:
        """
        Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "row_filter")

    @row_filter.setter
    def row_filter(self, value: Optional[pulumi.Input['PolicyInfoRowFilterArgs']]):
        pulumi.set(self, "row_filter", value)

    @_builtins.property
    @pulumi.getter(name="toPrincipals")
    def to_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of user or group names that the policy applies to.
        Required on create and optional on update
        """
        return pulumi.get(self, "to_principals")

    @to_principals.setter
    def to_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "to_principals", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - Time at which the policy was last modified, in epoch milliseconds. Output only
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Username of the user who last modified the policy. Output only
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)

    @_builtins.property
    @pulumi.getter(name="whenCondition")
    def when_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional condition when the policy should take effect
        """
        return pulumi.get(self, "when_condition")

    @when_condition.setter
    def when_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "when_condition", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/policyInfo:PolicyInfo")
class PolicyInfo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_mask: Optional[pulumi.Input[Union['PolicyInfoColumnMaskArgs', 'PolicyInfoColumnMaskArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 except_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 for_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyInfoMatchColumnArgs', 'PolicyInfoMatchColumnArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_fullname: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 row_filter: Optional[pulumi.Input[Union['PolicyInfoRowFilterArgs', 'PolicyInfoRowFilterArgsDict']]] = None,
                 to_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 when_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "on_securable_type,on_securable_fullname,name"

          to = databricks_policy_info.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/policyInfo:PolicyInfo databricks_policy_info "on_securable_type,on_securable_fullname,name"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyInfoColumnMaskArgs', 'PolicyInfoColumnMaskArgsDict']] column_mask: Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[_builtins.str] comment: Optional description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] except_principals: Optional list of user or group names that should be excluded from the policy
        :param pulumi.Input[_builtins.str] for_securable_type: Type of securables that the policy should take effect on.
               Only `TABLE` is supported at this moment.
               Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyInfoMatchColumnArgs', 'PolicyInfoMatchColumnArgsDict']]]] match_columns: Optional list of condition expressions used to match table columns.
               Only valid when `for_securable_type` is `TABLE`.
               When specified, the policy only applies to tables whose columns satisfy all match conditions
        :param pulumi.Input[_builtins.str] name: Name of the policy. Required on create and optional on update.
               To rename the policy, set `name` to a different value on update
        :param pulumi.Input[_builtins.str] on_securable_fullname: Full name of the securable on which the policy is defined.
               Required on create and ignored on update
        :param pulumi.Input[_builtins.str] on_securable_type: Type of the securable on which the policy is defined.
               Only `CATALOG`, `SCHEMA` and `TABLE` are supported at this moment.
               Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input[_builtins.str] policy_type: Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        :param pulumi.Input[Union['PolicyInfoRowFilterArgs', 'PolicyInfoRowFilterArgsDict']] row_filter: Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] to_principals: List of user or group names that the policy applies to.
               Required on create and optional on update
        :param pulumi.Input[_builtins.str] when_condition: Optional condition when the policy should take effect
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyInfoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "on_securable_type,on_securable_fullname,name"

          to = databricks_policy_info.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/policyInfo:PolicyInfo databricks_policy_info "on_securable_type,on_securable_fullname,name"
        ```

        :param str resource_name: The name of the resource.
        :param PolicyInfoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyInfoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_mask: Optional[pulumi.Input[Union['PolicyInfoColumnMaskArgs', 'PolicyInfoColumnMaskArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 except_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 for_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyInfoMatchColumnArgs', 'PolicyInfoMatchColumnArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_fullname: Optional[pulumi.Input[_builtins.str]] = None,
                 on_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 row_filter: Optional[pulumi.Input[Union['PolicyInfoRowFilterArgs', 'PolicyInfoRowFilterArgsDict']]] = None,
                 to_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 when_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyInfoArgs.__new__(PolicyInfoArgs)

            __props__.__dict__["column_mask"] = column_mask
            __props__.__dict__["comment"] = comment
            __props__.__dict__["except_principals"] = except_principals
            if for_securable_type is None and not opts.urn:
                raise TypeError("Missing required property 'for_securable_type'")
            __props__.__dict__["for_securable_type"] = for_securable_type
            __props__.__dict__["match_columns"] = match_columns
            __props__.__dict__["name"] = name
            __props__.__dict__["on_securable_fullname"] = on_securable_fullname
            __props__.__dict__["on_securable_type"] = on_securable_type
            if policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'policy_type'")
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["row_filter"] = row_filter
            if to_principals is None and not opts.urn:
                raise TypeError("Missing required property 'to_principals'")
            __props__.__dict__["to_principals"] = to_principals
            __props__.__dict__["when_condition"] = when_condition
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        super(PolicyInfo, __self__).__init__(
            'databricks:index/policyInfo:PolicyInfo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            column_mask: Optional[pulumi.Input[Union['PolicyInfoColumnMaskArgs', 'PolicyInfoColumnMaskArgsDict']]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            except_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            for_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
            match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyInfoMatchColumnArgs', 'PolicyInfoMatchColumnArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            on_securable_fullname: Optional[pulumi.Input[_builtins.str]] = None,
            on_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
            policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            row_filter: Optional[pulumi.Input[Union['PolicyInfoRowFilterArgs', 'PolicyInfoRowFilterArgsDict']]] = None,
            to_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.int]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            when_condition: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PolicyInfo':
        """
        Get an existing PolicyInfo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyInfoColumnMaskArgs', 'PolicyInfoColumnMaskArgsDict']] column_mask: Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[_builtins.str] comment: Optional description of the policy
        :param pulumi.Input[_builtins.int] created_at: (integer) - Time at which the policy was created, in epoch milliseconds. Output only
        :param pulumi.Input[_builtins.str] created_by: (string) - Username of the user who created the policy. Output only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] except_principals: Optional list of user or group names that should be excluded from the policy
        :param pulumi.Input[_builtins.str] for_securable_type: Type of securables that the policy should take effect on.
               Only `TABLE` is supported at this moment.
               Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyInfoMatchColumnArgs', 'PolicyInfoMatchColumnArgsDict']]]] match_columns: Optional list of condition expressions used to match table columns.
               Only valid when `for_securable_type` is `TABLE`.
               When specified, the policy only applies to tables whose columns satisfy all match conditions
        :param pulumi.Input[_builtins.str] name: Name of the policy. Required on create and optional on update.
               To rename the policy, set `name` to a different value on update
        :param pulumi.Input[_builtins.str] on_securable_fullname: Full name of the securable on which the policy is defined.
               Required on create and ignored on update
        :param pulumi.Input[_builtins.str] on_securable_type: Type of the securable on which the policy is defined.
               Only `CATALOG`, `SCHEMA` and `TABLE` are supported at this moment.
               Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        :param pulumi.Input[_builtins.str] policy_type: Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        :param pulumi.Input[Union['PolicyInfoRowFilterArgs', 'PolicyInfoRowFilterArgsDict']] row_filter: Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
               Required on create and optional on update. When specified on update,
               the new options will replace the existing options as a whole
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] to_principals: List of user or group names that the policy applies to.
               Required on create and optional on update
        :param pulumi.Input[_builtins.int] updated_at: (integer) - Time at which the policy was last modified, in epoch milliseconds. Output only
        :param pulumi.Input[_builtins.str] updated_by: (string) - Username of the user who last modified the policy. Output only
        :param pulumi.Input[_builtins.str] when_condition: Optional condition when the policy should take effect
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyInfoState.__new__(_PolicyInfoState)

        __props__.__dict__["column_mask"] = column_mask
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["except_principals"] = except_principals
        __props__.__dict__["for_securable_type"] = for_securable_type
        __props__.__dict__["match_columns"] = match_columns
        __props__.__dict__["name"] = name
        __props__.__dict__["on_securable_fullname"] = on_securable_fullname
        __props__.__dict__["on_securable_type"] = on_securable_type
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["row_filter"] = row_filter
        __props__.__dict__["to_principals"] = to_principals
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        __props__.__dict__["when_condition"] = when_condition
        __props__.__dict__["workspace_id"] = workspace_id
        return PolicyInfo(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="columnMask")
    def column_mask(self) -> pulumi.Output[Optional['outputs.PolicyInfoColumnMask']]:
        """
        Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "column_mask")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional description of the policy
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - Time at which the policy was created, in epoch milliseconds. Output only
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Username of the user who created the policy. Output only
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="exceptPrincipals")
    def except_principals(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Optional list of user or group names that should be excluded from the policy
        """
        return pulumi.get(self, "except_principals")

    @_builtins.property
    @pulumi.getter(name="forSecurableType")
    def for_securable_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of securables that the policy should take effect on.
        Only `TABLE` is supported at this moment.
        Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "for_securable_type")

    @_builtins.property
    @pulumi.getter(name="matchColumns")
    def match_columns(self) -> pulumi.Output[Optional[Sequence['outputs.PolicyInfoMatchColumn']]]:
        """
        Optional list of condition expressions used to match table columns.
        Only valid when `for_securable_type` is `TABLE`.
        When specified, the policy only applies to tables whose columns satisfy all match conditions
        """
        return pulumi.get(self, "match_columns")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the policy. Required on create and optional on update.
        To rename the policy, set `name` to a different value on update
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onSecurableFullname")
    def on_securable_fullname(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Full name of the securable on which the policy is defined.
        Required on create and ignored on update
        """
        return pulumi.get(self, "on_securable_fullname")

    @_builtins.property
    @pulumi.getter(name="onSecurableType")
    def on_securable_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of the securable on which the policy is defined.
        Only `CATALOG`, `SCHEMA` and `TABLE` are supported at this moment.
        Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "on_securable_type")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> pulumi.Output[Optional['outputs.PolicyInfoRowFilter']]:
        """
        Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "row_filter")

    @_builtins.property
    @pulumi.getter(name="toPrincipals")
    def to_principals(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of user or group names that the policy applies to.
        Required on create and optional on update
        """
        return pulumi.get(self, "to_principals")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - Time at which the policy was last modified, in epoch milliseconds. Output only
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Username of the user who last modified the policy. Output only
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="whenCondition")
    def when_condition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional condition when the policy should take effect
        """
        return pulumi.get(self, "when_condition")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

