# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServicePrincipalArgs', 'ServicePrincipal']

@pulumi.input_type
class ServicePrincipalArgs:
    def __init__(__self__, *,
                 acl_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_sql_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[_builtins.bool]] = None,
                 home: Optional[pulumi.Input[_builtins.str]] = None,
                 repos: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ServicePrincipal resource.
        :param pulumi.Input[_builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] active: Either service principal is active or not. True by default, but can be set to false in case of service principal deactivation with preserving service principal assets.
        :param pulumi.Input[_builtins.bool] allow_cluster_create: Allow the service principal to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within the boundaries of that specific policy.
        :param pulumi.Input[_builtins.bool] allow_instance_pool_create: Allow the service principal to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[_builtins.str] application_id: This is the Azure Application ID of the given Azure service principal and will be their form of access and identity. For Databricks-managed service principals this value is auto-generated.
        :param pulumi.Input[_builtins.bool] databricks_sql_access: This is a field to allow the service principal to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature through databricks_sql_endpoint.
        :param pulumi.Input[_builtins.bool] disable_as_user_deletion: Deactivate the service principal when deleting the resource, rather than deleting the service principal entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[_builtins.str] display_name: This is an alias for the service principal and can be the full name of the service principal.
        :param pulumi.Input[_builtins.str] external_id: ID of the service principal in an external identity provider.
        :param pulumi.Input[_builtins.bool] force: Ignore `cannot create service principal: Service principal with application ID X already exists` errors and implicitly import the specified service principal into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[_builtins.bool] force_delete_home_dir: This flag determines whether the service principal's home directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.bool] force_delete_repos: This flag determines whether the service principal's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.str] home: Home folder of the service principal, e.g. `/Users/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.str] repos: Personal Repos location of the service principal, e.g. `/Repos/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] workspace_access: This is a field to allow the service principal to have access to a Databricks Workspace.
        :param pulumi.Input[_builtins.bool] workspace_consume: This is a field to allow the service principal to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        if acl_principal_id is not None:
            pulumi.set(__self__, "acl_principal_id", acl_principal_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if allow_cluster_create is not None:
            pulumi.set(__self__, "allow_cluster_create", allow_cluster_create)
        if allow_instance_pool_create is not None:
            pulumi.set(__self__, "allow_instance_pool_create", allow_instance_pool_create)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if databricks_sql_access is not None:
            pulumi.set(__self__, "databricks_sql_access", databricks_sql_access)
        if disable_as_user_deletion is not None:
            pulumi.set(__self__, "disable_as_user_deletion", disable_as_user_deletion)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_delete_home_dir is not None:
            pulumi.set(__self__, "force_delete_home_dir", force_delete_home_dir)
        if force_delete_repos is not None:
            pulumi.set(__self__, "force_delete_repos", force_delete_repos)
        if home is not None:
            pulumi.set(__self__, "home", home)
        if repos is not None:
            pulumi.set(__self__, "repos", repos)
        if workspace_access is not None:
            pulumi.set(__self__, "workspace_access", workspace_access)
        if workspace_consume is not None:
            pulumi.set(__self__, "workspace_consume", workspace_consume)

    @_builtins.property
    @pulumi.getter(name="aclPrincipalId")
    def acl_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "acl_principal_id")

    @acl_principal_id.setter
    def acl_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_principal_id", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Either service principal is active or not. True by default, but can be set to false in case of service principal deactivation with preserving service principal assets.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="allowClusterCreate")
    def allow_cluster_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the service principal to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within the boundaries of that specific policy.
        """
        return pulumi.get(self, "allow_cluster_create")

    @allow_cluster_create.setter
    def allow_cluster_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_cluster_create", value)

    @_builtins.property
    @pulumi.getter(name="allowInstancePoolCreate")
    def allow_instance_pool_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the service principal to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        """
        return pulumi.get(self, "allow_instance_pool_create")

    @allow_instance_pool_create.setter
    def allow_instance_pool_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_instance_pool_create", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the Azure Application ID of the given Azure service principal and will be their form of access and identity. For Databricks-managed service principals this value is auto-generated.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="databricksSqlAccess")
    def databricks_sql_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature through databricks_sql_endpoint.
        """
        return pulumi.get(self, "databricks_sql_access")

    @databricks_sql_access.setter
    def databricks_sql_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "databricks_sql_access", value)

    @_builtins.property
    @pulumi.getter(name="disableAsUserDeletion")
    def disable_as_user_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deactivate the service principal when deleting the resource, rather than deleting the service principal entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        """
        return pulumi.get(self, "disable_as_user_deletion")

    @disable_as_user_deletion.setter
    def disable_as_user_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_as_user_deletion", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is an alias for the service principal and can be the full name of the service principal.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the service principal in an external identity provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Ignore `cannot create service principal: Service principal with application ID X already exists` errors and implicitly import the specified service principal into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteHomeDir")
    def force_delete_home_dir(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This flag determines whether the service principal's home directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_home_dir")

    @force_delete_home_dir.setter
    def force_delete_home_dir(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_home_dir", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteRepos")
    def force_delete_repos(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This flag determines whether the service principal's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_repos")

    @force_delete_repos.setter
    def force_delete_repos(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_repos", value)

    @_builtins.property
    @pulumi.getter
    def home(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Home folder of the service principal, e.g. `/Users/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "home")

    @home.setter
    def home(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home", value)

    @_builtins.property
    @pulumi.getter
    def repos(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Personal Repos location of the service principal, e.g. `/Repos/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repos", value)

    @_builtins.property
    @pulumi.getter(name="workspaceAccess")
    def workspace_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to a Databricks Workspace.
        """
        return pulumi.get(self, "workspace_access")

    @workspace_access.setter
    def workspace_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workspace_access", value)

    @_builtins.property
    @pulumi.getter(name="workspaceConsume")
    def workspace_consume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        return pulumi.get(self, "workspace_consume")

    @workspace_consume.setter
    def workspace_consume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workspace_consume", value)


@pulumi.input_type
class _ServicePrincipalState:
    def __init__(__self__, *,
                 acl_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_sql_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[_builtins.bool]] = None,
                 home: Optional[pulumi.Input[_builtins.str]] = None,
                 repos: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ServicePrincipal resources.
        :param pulumi.Input[_builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] active: Either service principal is active or not. True by default, but can be set to false in case of service principal deactivation with preserving service principal assets.
        :param pulumi.Input[_builtins.bool] allow_cluster_create: Allow the service principal to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within the boundaries of that specific policy.
        :param pulumi.Input[_builtins.bool] allow_instance_pool_create: Allow the service principal to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[_builtins.str] application_id: This is the Azure Application ID of the given Azure service principal and will be their form of access and identity. For Databricks-managed service principals this value is auto-generated.
        :param pulumi.Input[_builtins.bool] databricks_sql_access: This is a field to allow the service principal to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature through databricks_sql_endpoint.
        :param pulumi.Input[_builtins.bool] disable_as_user_deletion: Deactivate the service principal when deleting the resource, rather than deleting the service principal entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[_builtins.str] display_name: This is an alias for the service principal and can be the full name of the service principal.
        :param pulumi.Input[_builtins.str] external_id: ID of the service principal in an external identity provider.
        :param pulumi.Input[_builtins.bool] force: Ignore `cannot create service principal: Service principal with application ID X already exists` errors and implicitly import the specified service principal into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[_builtins.bool] force_delete_home_dir: This flag determines whether the service principal's home directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.bool] force_delete_repos: This flag determines whether the service principal's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.str] home: Home folder of the service principal, e.g. `/Users/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.str] repos: Personal Repos location of the service principal, e.g. `/Repos/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] workspace_access: This is a field to allow the service principal to have access to a Databricks Workspace.
        :param pulumi.Input[_builtins.bool] workspace_consume: This is a field to allow the service principal to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        if acl_principal_id is not None:
            pulumi.set(__self__, "acl_principal_id", acl_principal_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if allow_cluster_create is not None:
            pulumi.set(__self__, "allow_cluster_create", allow_cluster_create)
        if allow_instance_pool_create is not None:
            pulumi.set(__self__, "allow_instance_pool_create", allow_instance_pool_create)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if databricks_sql_access is not None:
            pulumi.set(__self__, "databricks_sql_access", databricks_sql_access)
        if disable_as_user_deletion is not None:
            pulumi.set(__self__, "disable_as_user_deletion", disable_as_user_deletion)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_delete_home_dir is not None:
            pulumi.set(__self__, "force_delete_home_dir", force_delete_home_dir)
        if force_delete_repos is not None:
            pulumi.set(__self__, "force_delete_repos", force_delete_repos)
        if home is not None:
            pulumi.set(__self__, "home", home)
        if repos is not None:
            pulumi.set(__self__, "repos", repos)
        if workspace_access is not None:
            pulumi.set(__self__, "workspace_access", workspace_access)
        if workspace_consume is not None:
            pulumi.set(__self__, "workspace_consume", workspace_consume)

    @_builtins.property
    @pulumi.getter(name="aclPrincipalId")
    def acl_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "acl_principal_id")

    @acl_principal_id.setter
    def acl_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_principal_id", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Either service principal is active or not. True by default, but can be set to false in case of service principal deactivation with preserving service principal assets.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="allowClusterCreate")
    def allow_cluster_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the service principal to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within the boundaries of that specific policy.
        """
        return pulumi.get(self, "allow_cluster_create")

    @allow_cluster_create.setter
    def allow_cluster_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_cluster_create", value)

    @_builtins.property
    @pulumi.getter(name="allowInstancePoolCreate")
    def allow_instance_pool_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the service principal to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        """
        return pulumi.get(self, "allow_instance_pool_create")

    @allow_instance_pool_create.setter
    def allow_instance_pool_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_instance_pool_create", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the Azure Application ID of the given Azure service principal and will be their form of access and identity. For Databricks-managed service principals this value is auto-generated.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="databricksSqlAccess")
    def databricks_sql_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature through databricks_sql_endpoint.
        """
        return pulumi.get(self, "databricks_sql_access")

    @databricks_sql_access.setter
    def databricks_sql_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "databricks_sql_access", value)

    @_builtins.property
    @pulumi.getter(name="disableAsUserDeletion")
    def disable_as_user_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deactivate the service principal when deleting the resource, rather than deleting the service principal entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        """
        return pulumi.get(self, "disable_as_user_deletion")

    @disable_as_user_deletion.setter
    def disable_as_user_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_as_user_deletion", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is an alias for the service principal and can be the full name of the service principal.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the service principal in an external identity provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Ignore `cannot create service principal: Service principal with application ID X already exists` errors and implicitly import the specified service principal into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteHomeDir")
    def force_delete_home_dir(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This flag determines whether the service principal's home directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_home_dir")

    @force_delete_home_dir.setter
    def force_delete_home_dir(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_home_dir", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteRepos")
    def force_delete_repos(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This flag determines whether the service principal's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_repos")

    @force_delete_repos.setter
    def force_delete_repos(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_repos", value)

    @_builtins.property
    @pulumi.getter
    def home(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Home folder of the service principal, e.g. `/Users/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "home")

    @home.setter
    def home(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home", value)

    @_builtins.property
    @pulumi.getter
    def repos(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Personal Repos location of the service principal, e.g. `/Repos/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repos", value)

    @_builtins.property
    @pulumi.getter(name="workspaceAccess")
    def workspace_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to a Databricks Workspace.
        """
        return pulumi.get(self, "workspace_access")

    @workspace_access.setter
    def workspace_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workspace_access", value)

    @_builtins.property
    @pulumi.getter(name="workspaceConsume")
    def workspace_consume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        return pulumi.get(self, "workspace_consume")

    @workspace_consume.setter
    def workspace_consume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workspace_consume", value)


@pulumi.type_token("databricks:index/servicePrincipal:ServicePrincipal")
class ServicePrincipal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_sql_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[_builtins.bool]] = None,
                 home: Optional[pulumi.Input[_builtins.str]] = None,
                 repos: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Directly manage [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html) that could be added to Group in Databricks account or workspace.

        > This resource can be used with an account or workspace-level provider.

        There are different types of service principals:

        * Databricks-managed - exists only inside the Databricks platform (all clouds) and couldn't be used for accessing non-Databricks services.
        * Azure-managed - existing Azure service principal (enterprise application) is registered inside Databricks.  It could be used to work with other Azure services.

        > To assign account level service principals to workspace use databricks_mws_permission_assignment.

        > Entitlements, like, `allow_cluster_create`, `allow_instance_pool_create`, `databricks_sql_access`, `workspace_access`, `workspace-consume` applicable only for workspace-level service principals. Use Entitlements resource to assign entitlements inside a workspace to account-level service principals.

        The default behavior when deleting a `ServicePrincipal` resource depends on whether the provider is configured at the workspace-level or account-level. When the provider is configured at the workspace-level, the service principal will be deleted from the workspace. When the provider is configured at the account-level, the service principal will be deactivated but not deleted. When the provider is configured at the account level, to delete the service principal from the account when the resource is deleted, set `disable_as_user_deletion = false`. Conversely, when the provider is configured at the account-level, to deactivate the service principal when the resource is deleted, set `disable_as_user_deletion = true`.

        ## Example Usage

        Creating regular Databricks-managed service principal:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", display_name="Admin SP")
        ```

        Creating service principal with administrative permissions - referencing special `admins` Group in GroupMember resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        admins = databricks.get_group(display_name="admins")
        sp = databricks.ServicePrincipal("sp", display_name="Admin SP")
        i_am_admin = databricks.GroupMember("i-am-admin",
            group_id=admins.id,
            member_id=sp.id)
        ```

        Creating Azure-managed service principal with cluster create permissions:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp",
            application_id="00000000-0000-0000-0000-000000000000",
            display_name="Example service principal",
            allow_cluster_create=True)
        ```

        Creating Databricks-managed service principal in AWS Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", display_name="Automation-only SP")
        ```

        Creating Azure-managed service principal in Azure Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", application_id="00000000-0000-0000-0000-000000000000")
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * Group to manage [Account-level](https://docs.databricks.com/aws/en/admin/users-groups/groups) or [Workspace-level](https://docs.databricks.com/aws/en/admin/users-groups/workspace-local-groups) groups.
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupMember to attach users and groups as group members.
        * Permissions to manage [access control](https://docs.databricks.com/security/access-control/index.html) in Databricks workspace.
        * Grants to manage data access in Unity Catalog.
        * ServicePrincipalSecret to manage secrets for a service principal.

        ## Import

        The resource scim service principal can be imported using its SCIM id, for example `2345678901234567`. To get the service principal ID, call [Get service principals](https://docs.databricks.com/dev-tools/api/latest/scim/scim-sp.html#get-service-principals).

        hcl

        import {

          to = databricks_service_principal.me

          id = "<service-principal-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/servicePrincipal:ServicePrincipal me <service-principal-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] active: Either service principal is active or not. True by default, but can be set to false in case of service principal deactivation with preserving service principal assets.
        :param pulumi.Input[_builtins.bool] allow_cluster_create: Allow the service principal to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within the boundaries of that specific policy.
        :param pulumi.Input[_builtins.bool] allow_instance_pool_create: Allow the service principal to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[_builtins.str] application_id: This is the Azure Application ID of the given Azure service principal and will be their form of access and identity. For Databricks-managed service principals this value is auto-generated.
        :param pulumi.Input[_builtins.bool] databricks_sql_access: This is a field to allow the service principal to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature through databricks_sql_endpoint.
        :param pulumi.Input[_builtins.bool] disable_as_user_deletion: Deactivate the service principal when deleting the resource, rather than deleting the service principal entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[_builtins.str] display_name: This is an alias for the service principal and can be the full name of the service principal.
        :param pulumi.Input[_builtins.str] external_id: ID of the service principal in an external identity provider.
        :param pulumi.Input[_builtins.bool] force: Ignore `cannot create service principal: Service principal with application ID X already exists` errors and implicitly import the specified service principal into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[_builtins.bool] force_delete_home_dir: This flag determines whether the service principal's home directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.bool] force_delete_repos: This flag determines whether the service principal's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.str] home: Home folder of the service principal, e.g. `/Users/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.str] repos: Personal Repos location of the service principal, e.g. `/Repos/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] workspace_access: This is a field to allow the service principal to have access to a Databricks Workspace.
        :param pulumi.Input[_builtins.bool] workspace_consume: This is a field to allow the service principal to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServicePrincipalArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Directly manage [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html) that could be added to Group in Databricks account or workspace.

        > This resource can be used with an account or workspace-level provider.

        There are different types of service principals:

        * Databricks-managed - exists only inside the Databricks platform (all clouds) and couldn't be used for accessing non-Databricks services.
        * Azure-managed - existing Azure service principal (enterprise application) is registered inside Databricks.  It could be used to work with other Azure services.

        > To assign account level service principals to workspace use databricks_mws_permission_assignment.

        > Entitlements, like, `allow_cluster_create`, `allow_instance_pool_create`, `databricks_sql_access`, `workspace_access`, `workspace-consume` applicable only for workspace-level service principals. Use Entitlements resource to assign entitlements inside a workspace to account-level service principals.

        The default behavior when deleting a `ServicePrincipal` resource depends on whether the provider is configured at the workspace-level or account-level. When the provider is configured at the workspace-level, the service principal will be deleted from the workspace. When the provider is configured at the account-level, the service principal will be deactivated but not deleted. When the provider is configured at the account level, to delete the service principal from the account when the resource is deleted, set `disable_as_user_deletion = false`. Conversely, when the provider is configured at the account-level, to deactivate the service principal when the resource is deleted, set `disable_as_user_deletion = true`.

        ## Example Usage

        Creating regular Databricks-managed service principal:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", display_name="Admin SP")
        ```

        Creating service principal with administrative permissions - referencing special `admins` Group in GroupMember resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        admins = databricks.get_group(display_name="admins")
        sp = databricks.ServicePrincipal("sp", display_name="Admin SP")
        i_am_admin = databricks.GroupMember("i-am-admin",
            group_id=admins.id,
            member_id=sp.id)
        ```

        Creating Azure-managed service principal with cluster create permissions:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp",
            application_id="00000000-0000-0000-0000-000000000000",
            display_name="Example service principal",
            allow_cluster_create=True)
        ```

        Creating Databricks-managed service principal in AWS Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", display_name="Automation-only SP")
        ```

        Creating Azure-managed service principal in Azure Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sp = databricks.ServicePrincipal("sp", application_id="00000000-0000-0000-0000-000000000000")
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * Group to manage [Account-level](https://docs.databricks.com/aws/en/admin/users-groups/groups) or [Workspace-level](https://docs.databricks.com/aws/en/admin/users-groups/workspace-local-groups) groups.
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupMember to attach users and groups as group members.
        * Permissions to manage [access control](https://docs.databricks.com/security/access-control/index.html) in Databricks workspace.
        * Grants to manage data access in Unity Catalog.
        * ServicePrincipalSecret to manage secrets for a service principal.

        ## Import

        The resource scim service principal can be imported using its SCIM id, for example `2345678901234567`. To get the service principal ID, call [Get service principals](https://docs.databricks.com/dev-tools/api/latest/scim/scim-sp.html#get-service-principals).

        hcl

        import {

          to = databricks_service_principal.me

          id = "<service-principal-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/servicePrincipal:ServicePrincipal me <service-principal-id>
        ```

        :param str resource_name: The name of the resource.
        :param ServicePrincipalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePrincipalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_sql_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[_builtins.bool]] = None,
                 home: Optional[pulumi.Input[_builtins.str]] = None,
                 repos: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePrincipalArgs.__new__(ServicePrincipalArgs)

            __props__.__dict__["acl_principal_id"] = acl_principal_id
            __props__.__dict__["active"] = active
            __props__.__dict__["allow_cluster_create"] = allow_cluster_create
            __props__.__dict__["allow_instance_pool_create"] = allow_instance_pool_create
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["databricks_sql_access"] = databricks_sql_access
            __props__.__dict__["disable_as_user_deletion"] = disable_as_user_deletion
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["force"] = force
            __props__.__dict__["force_delete_home_dir"] = force_delete_home_dir
            __props__.__dict__["force_delete_repos"] = force_delete_repos
            __props__.__dict__["home"] = home
            __props__.__dict__["repos"] = repos
            __props__.__dict__["workspace_access"] = workspace_access
            __props__.__dict__["workspace_consume"] = workspace_consume
        super(ServicePrincipal, __self__).__init__(
            'databricks:index/servicePrincipal:ServicePrincipal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_cluster_create: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_instance_pool_create: Optional[pulumi.Input[_builtins.bool]] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            databricks_sql_access: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_as_user_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete_home_dir: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete_repos: Optional[pulumi.Input[_builtins.bool]] = None,
            home: Optional[pulumi.Input[_builtins.str]] = None,
            repos: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_access: Optional[pulumi.Input[_builtins.bool]] = None,
            workspace_consume: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ServicePrincipal':
        """
        Get an existing ServicePrincipal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] active: Either service principal is active or not. True by default, but can be set to false in case of service principal deactivation with preserving service principal assets.
        :param pulumi.Input[_builtins.bool] allow_cluster_create: Allow the service principal to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within the boundaries of that specific policy.
        :param pulumi.Input[_builtins.bool] allow_instance_pool_create: Allow the service principal to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[_builtins.str] application_id: This is the Azure Application ID of the given Azure service principal and will be their form of access and identity. For Databricks-managed service principals this value is auto-generated.
        :param pulumi.Input[_builtins.bool] databricks_sql_access: This is a field to allow the service principal to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature through databricks_sql_endpoint.
        :param pulumi.Input[_builtins.bool] disable_as_user_deletion: Deactivate the service principal when deleting the resource, rather than deleting the service principal entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[_builtins.str] display_name: This is an alias for the service principal and can be the full name of the service principal.
        :param pulumi.Input[_builtins.str] external_id: ID of the service principal in an external identity provider.
        :param pulumi.Input[_builtins.bool] force: Ignore `cannot create service principal: Service principal with application ID X already exists` errors and implicitly import the specified service principal into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[_builtins.bool] force_delete_home_dir: This flag determines whether the service principal's home directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.bool] force_delete_repos: This flag determines whether the service principal's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[_builtins.str] home: Home folder of the service principal, e.g. `/Users/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.str] repos: Personal Repos location of the service principal, e.g. `/Repos/00000000-0000-0000-0000-000000000000`.
        :param pulumi.Input[_builtins.bool] workspace_access: This is a field to allow the service principal to have access to a Databricks Workspace.
        :param pulumi.Input[_builtins.bool] workspace_consume: This is a field to allow the service principal to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePrincipalState.__new__(_ServicePrincipalState)

        __props__.__dict__["acl_principal_id"] = acl_principal_id
        __props__.__dict__["active"] = active
        __props__.__dict__["allow_cluster_create"] = allow_cluster_create
        __props__.__dict__["allow_instance_pool_create"] = allow_instance_pool_create
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["databricks_sql_access"] = databricks_sql_access
        __props__.__dict__["disable_as_user_deletion"] = disable_as_user_deletion
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["force"] = force
        __props__.__dict__["force_delete_home_dir"] = force_delete_home_dir
        __props__.__dict__["force_delete_repos"] = force_delete_repos
        __props__.__dict__["home"] = home
        __props__.__dict__["repos"] = repos
        __props__.__dict__["workspace_access"] = workspace_access
        __props__.__dict__["workspace_consume"] = workspace_consume
        return ServicePrincipal(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclPrincipalId")
    def acl_principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        identifier for use in databricks_access_control_rule_set, e.g. `servicePrincipals/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "acl_principal_id")

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Either service principal is active or not. True by default, but can be set to false in case of service principal deactivation with preserving service principal assets.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="allowClusterCreate")
    def allow_cluster_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow the service principal to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within the boundaries of that specific policy.
        """
        return pulumi.get(self, "allow_cluster_create")

    @_builtins.property
    @pulumi.getter(name="allowInstancePoolCreate")
    def allow_instance_pool_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow the service principal to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        """
        return pulumi.get(self, "allow_instance_pool_create")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        This is the Azure Application ID of the given Azure service principal and will be their form of access and identity. For Databricks-managed service principals this value is auto-generated.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="databricksSqlAccess")
    def databricks_sql_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature through databricks_sql_endpoint.
        """
        return pulumi.get(self, "databricks_sql_access")

    @_builtins.property
    @pulumi.getter(name="disableAsUserDeletion")
    def disable_as_user_deletion(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Deactivate the service principal when deleting the resource, rather than deleting the service principal entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        """
        return pulumi.get(self, "disable_as_user_deletion")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        This is an alias for the service principal and can be the full name of the service principal.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the service principal in an external identity provider.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Ignore `cannot create service principal: Service principal with application ID X already exists` errors and implicitly import the specified service principal into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="forceDeleteHomeDir")
    def force_delete_home_dir(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This flag determines whether the service principal's home directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_home_dir")

    @_builtins.property
    @pulumi.getter(name="forceDeleteRepos")
    def force_delete_repos(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This flag determines whether the service principal's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_repos")

    @_builtins.property
    @pulumi.getter
    def home(self) -> pulumi.Output[_builtins.str]:
        """
        Home folder of the service principal, e.g. `/Users/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "home")

    @_builtins.property
    @pulumi.getter
    def repos(self) -> pulumi.Output[_builtins.str]:
        """
        Personal Repos location of the service principal, e.g. `/Repos/00000000-0000-0000-0000-000000000000`.
        """
        return pulumi.get(self, "repos")

    @_builtins.property
    @pulumi.getter(name="workspaceAccess")
    def workspace_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to a Databricks Workspace.
        """
        return pulumi.get(self, "workspace_access")

    @_builtins.property
    @pulumi.getter(name="workspaceConsume")
    def workspace_consume(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This is a field to allow the service principal to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        return pulumi.get(self, "workspace_consume")

