# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlTableArgs', 'SqlTable']

@pulumi.input_type
class SqlTableArgs:
    def __init__(__self__, *,
                 catalog_name: pulumi.Input[_builtins.str],
                 schema_name: pulumi.Input[_builtins.str],
                 table_type: pulumi.Input[_builtins.str],
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['SqlTableColumnArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 partitions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 storage_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 view_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlTable resource.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent catalog. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] table_type: Distinguishes a view vs. managed/external Table. `MANAGED`, `EXTERNAL`, `METRIC_VIEW` or `VIEW`. Change forces the creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_keys: a subset of columns to liquid cluster the table by. For automatic clustering, set `cluster_keys` to `["AUTO"]`. To turn off clustering, set it to `["NONE"]`. Conflicts with `partitions`.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text. Changing the comment is not currently supported on the `VIEW` table type.
        :param pulumi.Input[_builtins.str] data_source_format: External tables are supported in multiple data source formats. The string constants identifying these formats are `DELTA`, `CSV`, `JSON`, `AVRO`, `PARQUET`, `ORC`, and `TEXT`. Change forces the creation of a new resource. Not supported for `MANAGED` tables or `VIEW`.
        :param pulumi.Input[_builtins.str] name: Name of table relative to parent catalog and schema. Change forces the creation of a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Map of user defined table options. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: User name/group name/sp application_id of the table owner.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partitions: a subset of columns to partition the table by. Change forces the creation of a new resource. Conflicts with `cluster_keys`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of table properties.
        :param pulumi.Input[_builtins.str] storage_credential_name: For EXTERNAL Tables only: the name of storage credential to use. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_location: URL of storage location for Table data (required for EXTERNAL Tables). Not supported for `VIEW` or `MANAGED` table_type.
        :param pulumi.Input[_builtins.str] view_definition: SQL text defining the view (for `table_type == "VIEW"`). Not supported for `MANAGED` or `EXTERNAL` table_type.
        :param pulumi.Input[_builtins.str] warehouse_id: All table CRUD operations must be executed on a running cluster or SQL warehouse. If a `warehouse_id` is specified, that SQL warehouse will be used to execute SQL commands to manage this table. Conflicts with `cluster_id`.
        """
        pulumi.set(__self__, "catalog_name", catalog_name)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "table_type", table_type)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_keys is not None:
            pulumi.set(__self__, "cluster_keys", cluster_keys)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_source_format is not None:
            pulumi.set(__self__, "data_source_format", data_source_format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if storage_credential_name is not None:
            pulumi.set(__self__, "storage_credential_name", storage_credential_name)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if view_definition is not None:
            pulumi.set(__self__, "view_definition", view_definition)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of parent catalog. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "catalog_name", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of parent Schema relative to parent Catalog. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="tableType")
    def table_type(self) -> pulumi.Input[_builtins.str]:
        """
        Distinguishes a view vs. managed/external Table. `MANAGED`, `EXTERNAL`, `METRIC_VIEW` or `VIEW`. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "table_type")

    @table_type.setter
    def table_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        a subset of columns to liquid cluster the table by. For automatic clustering, set `cluster_keys` to `["AUTO"]`. To turn off clustering, set it to `["NONE"]`. Conflicts with `partitions`.
        """
        return pulumi.get(self, "cluster_keys")

    @cluster_keys.setter
    def cluster_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cluster_keys", value)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlTableColumnArgs']]]]:
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlTableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied free-form text. Changing the comment is not currently supported on the `VIEW` table type.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceFormat")
    def data_source_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External tables are supported in multiple data source formats. The string constants identifying these formats are `DELTA`, `CSV`, `JSON`, `AVRO`, `PARQUET`, `ORC`, and `TEXT`. Change forces the creation of a new resource. Not supported for `MANAGED` tables or `VIEW`.
        """
        return pulumi.get(self, "data_source_format")

    @data_source_format.setter
    def data_source_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of table relative to parent catalog and schema. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of user defined table options. Change forces creation of a new resource.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name/group name/sp application_id of the table owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        a subset of columns to partition the table by. Change forces the creation of a new resource. Conflicts with `cluster_keys`.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "partitions", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of table properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="storageCredentialName")
    def storage_credential_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For EXTERNAL Tables only: the name of storage credential to use. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "storage_credential_name")

    @storage_credential_name.setter
    def storage_credential_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_credential_name", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of storage location for Table data (required for EXTERNAL Tables). Not supported for `VIEW` or `MANAGED` table_type.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_location", value)

    @_builtins.property
    @pulumi.getter(name="viewDefinition")
    def view_definition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SQL text defining the view (for `table_type == "VIEW"`). Not supported for `MANAGED` or `EXTERNAL` table_type.
        """
        return pulumi.get(self, "view_definition")

    @view_definition.setter
    def view_definition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "view_definition", value)

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All table CRUD operations must be executed on a running cluster or SQL warehouse. If a `warehouse_id` is specified, that SQL warehouse will be used to execute SQL commands to manage this table. Conflicts with `cluster_id`.
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.input_type
class _SqlTableState:
    def __init__(__self__, *,
                 catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['SqlTableColumnArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_format: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 partitions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 view_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlTable resources.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent catalog. Change forces the creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_keys: a subset of columns to liquid cluster the table by. For automatic clustering, set `cluster_keys` to `["AUTO"]`. To turn off clustering, set it to `["NONE"]`. Conflicts with `partitions`.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text. Changing the comment is not currently supported on the `VIEW` table type.
        :param pulumi.Input[_builtins.str] data_source_format: External tables are supported in multiple data source formats. The string constants identifying these formats are `DELTA`, `CSV`, `JSON`, `AVRO`, `PARQUET`, `ORC`, and `TEXT`. Change forces the creation of a new resource. Not supported for `MANAGED` tables or `VIEW`.
        :param pulumi.Input[_builtins.str] name: Name of table relative to parent catalog and schema. Change forces the creation of a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Map of user defined table options. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: User name/group name/sp application_id of the table owner.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partitions: a subset of columns to partition the table by. Change forces the creation of a new resource. Conflicts with `cluster_keys`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of table properties.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_credential_name: For EXTERNAL Tables only: the name of storage credential to use. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_location: URL of storage location for Table data (required for EXTERNAL Tables). Not supported for `VIEW` or `MANAGED` table_type.
        :param pulumi.Input[_builtins.str] table_type: Distinguishes a view vs. managed/external Table. `MANAGED`, `EXTERNAL`, `METRIC_VIEW` or `VIEW`. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] view_definition: SQL text defining the view (for `table_type == "VIEW"`). Not supported for `MANAGED` or `EXTERNAL` table_type.
        :param pulumi.Input[_builtins.str] warehouse_id: All table CRUD operations must be executed on a running cluster or SQL warehouse. If a `warehouse_id` is specified, that SQL warehouse will be used to execute SQL commands to manage this table. Conflicts with `cluster_id`.
        """
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_keys is not None:
            pulumi.set(__self__, "cluster_keys", cluster_keys)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_source_format is not None:
            pulumi.set(__self__, "data_source_format", data_source_format)
        if effective_properties is not None:
            pulumi.set(__self__, "effective_properties", effective_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if storage_credential_name is not None:
            pulumi.set(__self__, "storage_credential_name", storage_credential_name)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if table_type is not None:
            pulumi.set(__self__, "table_type", table_type)
        if view_definition is not None:
            pulumi.set(__self__, "view_definition", view_definition)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of parent catalog. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        a subset of columns to liquid cluster the table by. For automatic clustering, set `cluster_keys` to `["AUTO"]`. To turn off clustering, set it to `["NONE"]`. Conflicts with `partitions`.
        """
        return pulumi.get(self, "cluster_keys")

    @cluster_keys.setter
    def cluster_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cluster_keys", value)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlTableColumnArgs']]]]:
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlTableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied free-form text. Changing the comment is not currently supported on the `VIEW` table type.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceFormat")
    def data_source_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External tables are supported in multiple data source formats. The string constants identifying these formats are `DELTA`, `CSV`, `JSON`, `AVRO`, `PARQUET`, `ORC`, and `TEXT`. Change forces the creation of a new resource. Not supported for `MANAGED` tables or `VIEW`.
        """
        return pulumi.get(self, "data_source_format")

    @data_source_format.setter
    def data_source_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_format", value)

    @_builtins.property
    @pulumi.getter(name="effectiveProperties")
    def effective_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_properties")

    @effective_properties.setter
    def effective_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_properties", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of table relative to parent catalog and schema. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of user defined table options. Change forces creation of a new resource.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name/group name/sp application_id of the table owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        a subset of columns to partition the table by. Change forces the creation of a new resource. Conflicts with `cluster_keys`.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "partitions", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of table properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of parent Schema relative to parent Catalog. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="storageCredentialName")
    def storage_credential_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For EXTERNAL Tables only: the name of storage credential to use. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "storage_credential_name")

    @storage_credential_name.setter
    def storage_credential_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_credential_name", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of storage location for Table data (required for EXTERNAL Tables). Not supported for `VIEW` or `MANAGED` table_type.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_location", value)

    @_builtins.property
    @pulumi.getter(name="tableType")
    def table_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Distinguishes a view vs. managed/external Table. `MANAGED`, `EXTERNAL`, `METRIC_VIEW` or `VIEW`. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "table_type")

    @table_type.setter
    def table_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_type", value)

    @_builtins.property
    @pulumi.getter(name="viewDefinition")
    def view_definition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SQL text defining the view (for `table_type == "VIEW"`). Not supported for `MANAGED` or `EXTERNAL` table_type.
        """
        return pulumi.get(self, "view_definition")

    @view_definition.setter
    def view_definition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "view_definition", value)

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All table CRUD operations must be executed on a running cluster or SQL warehouse. If a `warehouse_id` is specified, that SQL warehouse will be used to execute SQL commands to manage this table. Conflicts with `cluster_id`.
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.type_token("databricks:index/sqlTable:SqlTable")
class SqlTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlTableColumnArgs', 'SqlTableColumnArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 partitions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 view_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This resource can be imported by its full name:

        hcl

        import {

          to = databricks_sql_table.this

          id = "<catalog_name>.<schema_name>.<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/sqlTable:SqlTable this "<catalog_name>.<schema_name>.<name>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent catalog. Change forces the creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_keys: a subset of columns to liquid cluster the table by. For automatic clustering, set `cluster_keys` to `["AUTO"]`. To turn off clustering, set it to `["NONE"]`. Conflicts with `partitions`.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text. Changing the comment is not currently supported on the `VIEW` table type.
        :param pulumi.Input[_builtins.str] data_source_format: External tables are supported in multiple data source formats. The string constants identifying these formats are `DELTA`, `CSV`, `JSON`, `AVRO`, `PARQUET`, `ORC`, and `TEXT`. Change forces the creation of a new resource. Not supported for `MANAGED` tables or `VIEW`.
        :param pulumi.Input[_builtins.str] name: Name of table relative to parent catalog and schema. Change forces the creation of a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Map of user defined table options. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: User name/group name/sp application_id of the table owner.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partitions: a subset of columns to partition the table by. Change forces the creation of a new resource. Conflicts with `cluster_keys`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of table properties.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_credential_name: For EXTERNAL Tables only: the name of storage credential to use. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_location: URL of storage location for Table data (required for EXTERNAL Tables). Not supported for `VIEW` or `MANAGED` table_type.
        :param pulumi.Input[_builtins.str] table_type: Distinguishes a view vs. managed/external Table. `MANAGED`, `EXTERNAL`, `METRIC_VIEW` or `VIEW`. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] view_definition: SQL text defining the view (for `table_type == "VIEW"`). Not supported for `MANAGED` or `EXTERNAL` table_type.
        :param pulumi.Input[_builtins.str] warehouse_id: All table CRUD operations must be executed on a running cluster or SQL warehouse. If a `warehouse_id` is specified, that SQL warehouse will be used to execute SQL commands to manage this table. Conflicts with `cluster_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This resource can be imported by its full name:

        hcl

        import {

          to = databricks_sql_table.this

          id = "<catalog_name>.<schema_name>.<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/sqlTable:SqlTable this "<catalog_name>.<schema_name>.<name>"
        ```

        :param str resource_name: The name of the resource.
        :param SqlTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlTableColumnArgs', 'SqlTableColumnArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 partitions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 view_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlTableArgs.__new__(SqlTableArgs)

            if catalog_name is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_name'")
            __props__.__dict__["catalog_name"] = catalog_name
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["cluster_keys"] = cluster_keys
            __props__.__dict__["columns"] = columns
            __props__.__dict__["comment"] = comment
            __props__.__dict__["data_source_format"] = data_source_format
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["owner"] = owner
            __props__.__dict__["partitions"] = partitions
            __props__.__dict__["properties"] = properties
            if schema_name is None and not opts.urn:
                raise TypeError("Missing required property 'schema_name'")
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["storage_credential_name"] = storage_credential_name
            __props__.__dict__["storage_location"] = storage_location
            if table_type is None and not opts.urn:
                raise TypeError("Missing required property 'table_type'")
            __props__.__dict__["table_type"] = table_type
            __props__.__dict__["view_definition"] = view_definition
            __props__.__dict__["warehouse_id"] = warehouse_id
            __props__.__dict__["effective_properties"] = None
        super(SqlTable, __self__).__init__(
            'databricks:index/sqlTable:SqlTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlTableColumnArgs', 'SqlTableColumnArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_format: Optional[pulumi.Input[_builtins.str]] = None,
            effective_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            partitions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_location: Optional[pulumi.Input[_builtins.str]] = None,
            table_type: Optional[pulumi.Input[_builtins.str]] = None,
            view_definition: Optional[pulumi.Input[_builtins.str]] = None,
            warehouse_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlTable':
        """
        Get an existing SqlTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent catalog. Change forces the creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_keys: a subset of columns to liquid cluster the table by. For automatic clustering, set `cluster_keys` to `["AUTO"]`. To turn off clustering, set it to `["NONE"]`. Conflicts with `partitions`.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text. Changing the comment is not currently supported on the `VIEW` table type.
        :param pulumi.Input[_builtins.str] data_source_format: External tables are supported in multiple data source formats. The string constants identifying these formats are `DELTA`, `CSV`, `JSON`, `AVRO`, `PARQUET`, `ORC`, and `TEXT`. Change forces the creation of a new resource. Not supported for `MANAGED` tables or `VIEW`.
        :param pulumi.Input[_builtins.str] name: Name of table relative to parent catalog and schema. Change forces the creation of a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Map of user defined table options. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: User name/group name/sp application_id of the table owner.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partitions: a subset of columns to partition the table by. Change forces the creation of a new resource. Conflicts with `cluster_keys`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of table properties.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_credential_name: For EXTERNAL Tables only: the name of storage credential to use. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_location: URL of storage location for Table data (required for EXTERNAL Tables). Not supported for `VIEW` or `MANAGED` table_type.
        :param pulumi.Input[_builtins.str] table_type: Distinguishes a view vs. managed/external Table. `MANAGED`, `EXTERNAL`, `METRIC_VIEW` or `VIEW`. Change forces the creation of a new resource.
        :param pulumi.Input[_builtins.str] view_definition: SQL text defining the view (for `table_type == "VIEW"`). Not supported for `MANAGED` or `EXTERNAL` table_type.
        :param pulumi.Input[_builtins.str] warehouse_id: All table CRUD operations must be executed on a running cluster or SQL warehouse. If a `warehouse_id` is specified, that SQL warehouse will be used to execute SQL commands to manage this table. Conflicts with `cluster_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlTableState.__new__(_SqlTableState)

        __props__.__dict__["catalog_name"] = catalog_name
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_keys"] = cluster_keys
        __props__.__dict__["columns"] = columns
        __props__.__dict__["comment"] = comment
        __props__.__dict__["data_source_format"] = data_source_format
        __props__.__dict__["effective_properties"] = effective_properties
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["owner"] = owner
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["properties"] = properties
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["storage_credential_name"] = storage_credential_name
        __props__.__dict__["storage_location"] = storage_location
        __props__.__dict__["table_type"] = table_type
        __props__.__dict__["view_definition"] = view_definition
        __props__.__dict__["warehouse_id"] = warehouse_id
        return SqlTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of parent catalog. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        a subset of columns to liquid cluster the table by. For automatic clustering, set `cluster_keys` to `["AUTO"]`. To turn off clustering, set it to `["NONE"]`. Conflicts with `partitions`.
        """
        return pulumi.get(self, "cluster_keys")

    @_builtins.property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Sequence['outputs.SqlTableColumn']]:
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-supplied free-form text. Changing the comment is not currently supported on the `VIEW` table type.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="dataSourceFormat")
    def data_source_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External tables are supported in multiple data source formats. The string constants identifying these formats are `DELTA`, `CSV`, `JSON`, `AVRO`, `PARQUET`, `ORC`, and `TEXT`. Change forces the creation of a new resource. Not supported for `MANAGED` tables or `VIEW`.
        """
        return pulumi.get(self, "data_source_format")

    @_builtins.property
    @pulumi.getter(name="effectiveProperties")
    def effective_properties(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_properties")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of table relative to parent catalog and schema. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of user defined table options. Change forces creation of a new resource.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        User name/group name/sp application_id of the table owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        a subset of columns to partition the table by. Change forces the creation of a new resource. Conflicts with `cluster_keys`.
        """
        return pulumi.get(self, "partitions")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of table properties.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of parent Schema relative to parent Catalog. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="storageCredentialName")
    def storage_credential_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For EXTERNAL Tables only: the name of storage credential to use. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "storage_credential_name")

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of storage location for Table data (required for EXTERNAL Tables). Not supported for `VIEW` or `MANAGED` table_type.
        """
        return pulumi.get(self, "storage_location")

    @_builtins.property
    @pulumi.getter(name="tableType")
    def table_type(self) -> pulumi.Output[_builtins.str]:
        """
        Distinguishes a view vs. managed/external Table. `MANAGED`, `EXTERNAL`, `METRIC_VIEW` or `VIEW`. Change forces the creation of a new resource.
        """
        return pulumi.get(self, "table_type")

    @_builtins.property
    @pulumi.getter(name="viewDefinition")
    def view_definition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SQL text defining the view (for `table_type == "VIEW"`). Not supported for `MANAGED` or `EXTERNAL` table_type.
        """
        return pulumi.get(self, "view_definition")

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        All table CRUD operations must be executed on a running cluster or SQL warehouse. If a `warehouse_id` is specified, that SQL warehouse will be used to execute SQL commands to manage this table. Conflicts with `cluster_id`.
        """
        return pulumi.get(self, "warehouse_id")

