# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AccessRecord(object):
    _types = {
        "access_record_id": int,
        "user_id": str,
        "device_id": int,
        "is_clock_in": bool,
        "access_time": int,
        "access_type": str,
        "access_data": str,
        "is_door_open": bool,
    }

    def __init__(self, d=None):
        self.access_record_id: Optional[int] = None
        self.user_id: Optional[str] = None
        self.device_id: Optional[int] = None
        self.is_clock_in: Optional[bool] = None
        self.access_time: Optional[int] = None
        self.access_type: Optional[str] = None
        self.access_data: Optional[str] = None
        self.is_door_open: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AccessRecordBuilder":
        return AccessRecordBuilder()


class AccessRecordBuilder(object):
    def __init__(self) -> None:
        self._access_record = AccessRecord()

    def access_record_id(self, access_record_id: int) -> "AccessRecordBuilder":
        self._access_record.access_record_id = access_record_id
        return self

    def user_id(self, user_id: str) -> "AccessRecordBuilder":
        self._access_record.user_id = user_id
        return self

    def device_id(self, device_id: int) -> "AccessRecordBuilder":
        self._access_record.device_id = device_id
        return self

    def is_clock_in(self, is_clock_in: bool) -> "AccessRecordBuilder":
        self._access_record.is_clock_in = is_clock_in
        return self

    def access_time(self, access_time: int) -> "AccessRecordBuilder":
        self._access_record.access_time = access_time
        return self

    def access_type(self, access_type: str) -> "AccessRecordBuilder":
        self._access_record.access_type = access_type
        return self

    def access_data(self, access_data: str) -> "AccessRecordBuilder":
        self._access_record.access_data = access_data
        return self

    def is_door_open(self, is_door_open: bool) -> "AccessRecordBuilder":
        self._access_record.is_door_open = is_door_open
        return self

    def build(self) -> "AccessRecord":
        return self._access_record
