# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetAccessRecordAccessPhotoRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.access_record_id: Optional[int] = None

    @staticmethod
    def builder() -> "GetAccessRecordAccessPhotoRequestBuilder":
        return GetAccessRecordAccessPhotoRequestBuilder()


class GetAccessRecordAccessPhotoRequestBuilder(object):

    def __init__(self) -> None:
        get_access_record_access_photo_request = GetAccessRecordAccessPhotoRequest()
        get_access_record_access_photo_request.http_method = HttpMethod.GET
        get_access_record_access_photo_request.uri = "/open-apis/acs/v1/access_records/:access_record_id/access_photo"
        get_access_record_access_photo_request.token_types = {AccessTokenType.TENANT}
        self._get_access_record_access_photo_request: GetAccessRecordAccessPhotoRequest = get_access_record_access_photo_request

    def access_record_id(self, access_record_id: int) -> "GetAccessRecordAccessPhotoRequestBuilder":
        self._get_access_record_access_photo_request.access_record_id = access_record_id
        self._get_access_record_access_photo_request.paths["access_record_id"] = str(access_record_id)
        return self

    def build(self) -> GetAccessRecordAccessPhotoRequest:
        return self._get_access_record_access_photo_request
