# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .opening_time_period_external import OpeningTimePeriodExternal
from .opening_time_valid_day_external import OpeningTimeValidDayExternal


class OpeningTimeExternal(object):
    _types = {
        "valid_day": OpeningTimeValidDayExternal,
        "weekdays": List[int],
        "day_times": List[OpeningTimePeriodExternal],
    }

    def __init__(self, d=None):
        self.valid_day: Optional[OpeningTimeValidDayExternal] = None
        self.weekdays: Optional[List[int]] = None
        self.day_times: Optional[List[OpeningTimePeriodExternal]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OpeningTimeExternalBuilder":
        return OpeningTimeExternalBuilder()


class OpeningTimeExternalBuilder(object):
    def __init__(self) -> None:
        self._opening_time_external = OpeningTimeExternal()

    def valid_day(self, valid_day: OpeningTimeValidDayExternal) -> "OpeningTimeExternalBuilder":
        self._opening_time_external.valid_day = valid_day
        return self

    def weekdays(self, weekdays: List[int]) -> "OpeningTimeExternalBuilder":
        self._opening_time_external.weekdays = weekdays
        return self

    def day_times(self, day_times: List[OpeningTimePeriodExternal]) -> "OpeningTimeExternalBuilder":
        self._opening_time_external.day_times = day_times
        return self

    def build(self) -> "OpeningTimeExternal":
        return self._opening_time_external
