# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .feature import Feature


class User(object):
    _types = {
        "feature": Feature,
        "user_id": str,
    }

    def __init__(self, d=None):
        self.feature: Optional[Feature] = None
        self.user_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserBuilder":
        return UserBuilder()


class UserBuilder(object):
    def __init__(self) -> None:
        self._user = User()

    def feature(self, feature: Feature) -> "UserBuilder":
        self._user.feature = feature
        return self

    def user_id(self, user_id: str) -> "UserBuilder":
        self._user.user_id = user_id
        return self

    def build(self) -> "User":
        return self._user
