# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class UserExternal(object):
    _types = {
        "user_type": int,
        "user_id": int,
        "user_name": str,
        "phone_num": str,
        "department_id": int,
    }

    def __init__(self, d=None):
        self.user_type: Optional[int] = None
        self.user_id: Optional[int] = None
        self.user_name: Optional[str] = None
        self.phone_num: Optional[str] = None
        self.department_id: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserExternalBuilder":
        return UserExternalBuilder()


class UserExternalBuilder(object):
    def __init__(self) -> None:
        self._user_external = UserExternal()

    def user_type(self, user_type: int) -> "UserExternalBuilder":
        self._user_external.user_type = user_type
        return self

    def user_id(self, user_id: int) -> "UserExternalBuilder":
        self._user_external.user_id = user_id
        return self

    def user_name(self, user_name: str) -> "UserExternalBuilder":
        self._user_external.user_name = user_name
        return self

    def phone_num(self, phone_num: str) -> "UserExternalBuilder":
        self._user_external.phone_num = phone_num
        return self

    def department_id(self, department_id: int) -> "UserExternalBuilder":
        self._user_external.department_id = department_id
        return self

    def build(self) -> "UserExternal":
        return self._user_external
