# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_visitor_request import CreateVisitorRequest
from ..model.create_visitor_response import CreateVisitorResponse
from ..model.delete_visitor_request import DeleteVisitorRequest
from ..model.delete_visitor_response import DeleteVisitorResponse


class Visitor(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateVisitorRequest, option: Optional[RequestOption] = None) -> CreateVisitorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateVisitorResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateVisitorResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateVisitorRequest,
                      option: Optional[RequestOption] = None) -> CreateVisitorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateVisitorResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateVisitorResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteVisitorRequest, option: Optional[RequestOption] = None) -> DeleteVisitorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteVisitorResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteVisitorResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteVisitorRequest,
                      option: Optional[RequestOption] = None) -> DeleteVisitorResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteVisitorResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteVisitorResponse)
        response.raw = resp

        return response
