# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AuditEventExtend(object):
    _types = {
        "comment_type": str,
        "app_detail": str,
        "two_step_validation": bool,
        "login_method": str,
        "new_people_num_in_video": int,
        "external_people_num_in_video": int,
        "external_people_num_in_chat": int,
        "join_group": int,
        "quit_group": int,
        "external_people_num_in_doc_share": int,
    }

    def __init__(self, d=None):
        self.comment_type: Optional[str] = None
        self.app_detail: Optional[str] = None
        self.two_step_validation: Optional[bool] = None
        self.login_method: Optional[str] = None
        self.new_people_num_in_video: Optional[int] = None
        self.external_people_num_in_video: Optional[int] = None
        self.external_people_num_in_chat: Optional[int] = None
        self.join_group: Optional[int] = None
        self.quit_group: Optional[int] = None
        self.external_people_num_in_doc_share: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AuditEventExtendBuilder":
        return AuditEventExtendBuilder()


class AuditEventExtendBuilder(object):
    def __init__(self) -> None:
        self._audit_event_extend = AuditEventExtend()

    def comment_type(self, comment_type: str) -> "AuditEventExtendBuilder":
        self._audit_event_extend.comment_type = comment_type
        return self

    def app_detail(self, app_detail: str) -> "AuditEventExtendBuilder":
        self._audit_event_extend.app_detail = app_detail
        return self

    def two_step_validation(self, two_step_validation: bool) -> "AuditEventExtendBuilder":
        self._audit_event_extend.two_step_validation = two_step_validation
        return self

    def login_method(self, login_method: str) -> "AuditEventExtendBuilder":
        self._audit_event_extend.login_method = login_method
        return self

    def new_people_num_in_video(self, new_people_num_in_video: int) -> "AuditEventExtendBuilder":
        self._audit_event_extend.new_people_num_in_video = new_people_num_in_video
        return self

    def external_people_num_in_video(self, external_people_num_in_video: int) -> "AuditEventExtendBuilder":
        self._audit_event_extend.external_people_num_in_video = external_people_num_in_video
        return self

    def external_people_num_in_chat(self, external_people_num_in_chat: int) -> "AuditEventExtendBuilder":
        self._audit_event_extend.external_people_num_in_chat = external_people_num_in_chat
        return self

    def join_group(self, join_group: int) -> "AuditEventExtendBuilder":
        self._audit_event_extend.join_group = join_group
        return self

    def quit_group(self, quit_group: int) -> "AuditEventExtendBuilder":
        self._audit_event_extend.quit_group = quit_group
        return self

    def external_people_num_in_doc_share(self, external_people_num_in_doc_share: int) -> "AuditEventExtendBuilder":
        self._audit_event_extend.external_people_num_in_doc_share = external_people_num_in_doc_share
        return self

    def build(self) -> "AuditEventExtend":
        return self._audit_event_extend
