# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .api_audit_common_drawers import ApiAuditCommonDrawers
from .audit_context import AuditContext
from .audit_detail import AuditDetail
from .audit_event_extend import AuditEventExtend
from .audit_object_entity import AuditObjectEntity
from .audit_recipient_entity import AuditRecipientEntity


class AuditInfo(object):
    _types = {
        "event_id": str,
        "unique_id": str,
        "event_name": str,
        "department_ids": List[str],
        "event_module": int,
        "operator_type": int,
        "operator_value": str,
        "objects": List[AuditObjectEntity],
        "recipients": List[AuditRecipientEntity],
        "event_time": int,
        "ip": str,
        "operator_app": str,
        "audit_context": AuditContext,
        "extend": AuditEventExtend,
        "operator_app_name": str,
        "common_drawers": ApiAuditCommonDrawers,
        "audit_detail": AuditDetail,
    }

    def __init__(self, d=None):
        self.event_id: Optional[str] = None
        self.unique_id: Optional[str] = None
        self.event_name: Optional[str] = None
        self.department_ids: Optional[List[str]] = None
        self.event_module: Optional[int] = None
        self.operator_type: Optional[int] = None
        self.operator_value: Optional[str] = None
        self.objects: Optional[List[AuditObjectEntity]] = None
        self.recipients: Optional[List[AuditRecipientEntity]] = None
        self.event_time: Optional[int] = None
        self.ip: Optional[str] = None
        self.operator_app: Optional[str] = None
        self.audit_context: Optional[AuditContext] = None
        self.extend: Optional[AuditEventExtend] = None
        self.operator_app_name: Optional[str] = None
        self.common_drawers: Optional[ApiAuditCommonDrawers] = None
        self.audit_detail: Optional[AuditDetail] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AuditInfoBuilder":
        return AuditInfoBuilder()


class AuditInfoBuilder(object):
    def __init__(self) -> None:
        self._audit_info = AuditInfo()

    def event_id(self, event_id: str) -> "AuditInfoBuilder":
        self._audit_info.event_id = event_id
        return self

    def unique_id(self, unique_id: str) -> "AuditInfoBuilder":
        self._audit_info.unique_id = unique_id
        return self

    def event_name(self, event_name: str) -> "AuditInfoBuilder":
        self._audit_info.event_name = event_name
        return self

    def department_ids(self, department_ids: List[str]) -> "AuditInfoBuilder":
        self._audit_info.department_ids = department_ids
        return self

    def event_module(self, event_module: int) -> "AuditInfoBuilder":
        self._audit_info.event_module = event_module
        return self

    def operator_type(self, operator_type: int) -> "AuditInfoBuilder":
        self._audit_info.operator_type = operator_type
        return self

    def operator_value(self, operator_value: str) -> "AuditInfoBuilder":
        self._audit_info.operator_value = operator_value
        return self

    def objects(self, objects: List[AuditObjectEntity]) -> "AuditInfoBuilder":
        self._audit_info.objects = objects
        return self

    def recipients(self, recipients: List[AuditRecipientEntity]) -> "AuditInfoBuilder":
        self._audit_info.recipients = recipients
        return self

    def event_time(self, event_time: int) -> "AuditInfoBuilder":
        self._audit_info.event_time = event_time
        return self

    def ip(self, ip: str) -> "AuditInfoBuilder":
        self._audit_info.ip = ip
        return self

    def operator_app(self, operator_app: str) -> "AuditInfoBuilder":
        self._audit_info.operator_app = operator_app
        return self

    def audit_context(self, audit_context: AuditContext) -> "AuditInfoBuilder":
        self._audit_info.audit_context = audit_context
        return self

    def extend(self, extend: AuditEventExtend) -> "AuditInfoBuilder":
        self._audit_info.extend = extend
        return self

    def operator_app_name(self, operator_app_name: str) -> "AuditInfoBuilder":
        self._audit_info.operator_app_name = operator_app_name
        return self

    def common_drawers(self, common_drawers: ApiAuditCommonDrawers) -> "AuditInfoBuilder":
        self._audit_info.common_drawers = common_drawers
        return self

    def audit_detail(self, audit_detail: AuditDetail) -> "AuditInfoBuilder":
        self._audit_info.audit_detail = audit_detail
        return self

    def build(self) -> "AuditInfo":
        return self._audit_info
