# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AuditIosContext(object):
    _types = {
        "udid": str,
        "did": str,
        "app_ver": str,
        "ver": str,
        "os": str,
        "s_t_zone": str,
        "m_l": str,
        "sjd": str,
        "proxyip": str,
        "wifip": str,
        "location": str,
        "active_ip": str,
        "active_ip_detail": str,
        "cell_base_station": str,
        "i_p": str,
    }

    def __init__(self, d=None):
        self.udid: Optional[str] = None
        self.did: Optional[str] = None
        self.app_ver: Optional[str] = None
        self.ver: Optional[str] = None
        self.os: Optional[str] = None
        self.s_t_zone: Optional[str] = None
        self.m_l: Optional[str] = None
        self.sjd: Optional[str] = None
        self.proxyip: Optional[str] = None
        self.wifip: Optional[str] = None
        self.location: Optional[str] = None
        self.active_ip: Optional[str] = None
        self.active_ip_detail: Optional[str] = None
        self.cell_base_station: Optional[str] = None
        self.i_p: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AuditIosContextBuilder":
        return AuditIosContextBuilder()


class AuditIosContextBuilder(object):
    def __init__(self) -> None:
        self._audit_ios_context = AuditIosContext()

    def udid(self, udid: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.udid = udid
        return self

    def did(self, did: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.did = did
        return self

    def app_ver(self, app_ver: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.app_ver = app_ver
        return self

    def ver(self, ver: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.ver = ver
        return self

    def os(self, os: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.os = os
        return self

    def s_t_zone(self, s_t_zone: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.s_t_zone = s_t_zone
        return self

    def m_l(self, m_l: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.m_l = m_l
        return self

    def sjd(self, sjd: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.sjd = sjd
        return self

    def proxyip(self, proxyip: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.proxyip = proxyip
        return self

    def wifip(self, wifip: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.wifip = wifip
        return self

    def location(self, location: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.location = location
        return self

    def active_ip(self, active_ip: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.active_ip = active_ip
        return self

    def active_ip_detail(self, active_ip_detail: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.active_ip_detail = active_ip_detail
        return self

    def cell_base_station(self, cell_base_station: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.cell_base_station = cell_base_station
        return self

    def i_p(self, i_p: str) -> "AuditIosContextBuilder":
        self._audit_ios_context.i_p = i_p
        return self

    def build(self) -> "AuditIosContext":
        return self._audit_ios_context
