# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .audit_object_detail import AuditObjectDetail


class AuditObjectEntity(object):
    _types = {
        "object_type": str,
        "object_value": str,
        "object_name": str,
        "object_owner": str,
        "object_detail": AuditObjectDetail,
    }

    def __init__(self, d=None):
        self.object_type: Optional[str] = None
        self.object_value: Optional[str] = None
        self.object_name: Optional[str] = None
        self.object_owner: Optional[str] = None
        self.object_detail: Optional[AuditObjectDetail] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AuditObjectEntityBuilder":
        return AuditObjectEntityBuilder()


class AuditObjectEntityBuilder(object):
    def __init__(self) -> None:
        self._audit_object_entity = AuditObjectEntity()

    def object_type(self, object_type: str) -> "AuditObjectEntityBuilder":
        self._audit_object_entity.object_type = object_type
        return self

    def object_value(self, object_value: str) -> "AuditObjectEntityBuilder":
        self._audit_object_entity.object_value = object_value
        return self

    def object_name(self, object_name: str) -> "AuditObjectEntityBuilder":
        self._audit_object_entity.object_name = object_name
        return self

    def object_owner(self, object_owner: str) -> "AuditObjectEntityBuilder":
        self._audit_object_entity.object_owner = object_owner
        return self

    def object_detail(self, object_detail: AuditObjectDetail) -> "AuditObjectEntityBuilder":
        self._audit_object_entity.object_detail = object_detail
        return self

    def build(self) -> "AuditObjectEntity":
        return self._audit_object_entity
