# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AuditPcContext(object):
    _types = {
        "udid": str,
        "did": str,
        "app_ver": str,
        "ver": str,
        "os": str,
        "wifip": str,
        "region": str,
        "i_p": str,
    }

    def __init__(self, d=None):
        self.udid: Optional[str] = None
        self.did: Optional[str] = None
        self.app_ver: Optional[str] = None
        self.ver: Optional[str] = None
        self.os: Optional[str] = None
        self.wifip: Optional[str] = None
        self.region: Optional[str] = None
        self.i_p: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AuditPcContextBuilder":
        return AuditPcContextBuilder()


class AuditPcContextBuilder(object):
    def __init__(self) -> None:
        self._audit_pc_context = AuditPcContext()

    def udid(self, udid: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.udid = udid
        return self

    def did(self, did: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.did = did
        return self

    def app_ver(self, app_ver: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.app_ver = app_ver
        return self

    def ver(self, ver: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.ver = ver
        return self

    def os(self, os: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.os = os
        return self

    def wifip(self, wifip: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.wifip = wifip
        return self

    def region(self, region: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.region = region
        return self

    def i_p(self, i_p: str) -> "AuditPcContextBuilder":
        self._audit_pc_context.i_p = i_p
        return self

    def build(self) -> "AuditPcContext":
        return self._audit_pc_context
