# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .audit_recipient_detail import AuditRecipientDetail


class AuditRecipientEntity(object):
    _types = {
        "recipient_type": str,
        "recipient_value": str,
        "recipient_detail": AuditRecipientDetail,
    }

    def __init__(self, d=None):
        self.recipient_type: Optional[str] = None
        self.recipient_value: Optional[str] = None
        self.recipient_detail: Optional[AuditRecipientDetail] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AuditRecipientEntityBuilder":
        return AuditRecipientEntityBuilder()


class AuditRecipientEntityBuilder(object):
    def __init__(self) -> None:
        self._audit_recipient_entity = AuditRecipientEntity()

    def recipient_type(self, recipient_type: str) -> "AuditRecipientEntityBuilder":
        self._audit_recipient_entity.recipient_type = recipient_type
        return self

    def recipient_value(self, recipient_value: str) -> "AuditRecipientEntityBuilder":
        self._audit_recipient_entity.recipient_value = recipient_value
        return self

    def recipient_detail(self, recipient_detail: AuditRecipientDetail) -> "AuditRecipientEntityBuilder":
        self._audit_recipient_entity.recipient_detail = recipient_detail
        return self

    def build(self) -> "AuditRecipientEntity":
        return self._audit_recipient_entity
