# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetBadgeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.badge_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetBadgeRequestBuilder":
        return GetBadgeRequestBuilder()


class GetBadgeRequestBuilder(object):

    def __init__(self) -> None:
        get_badge_request = GetBadgeRequest()
        get_badge_request.http_method = HttpMethod.GET
        get_badge_request.uri = "/open-apis/admin/v1/badges/:badge_id"
        get_badge_request.token_types = {AccessTokenType.TENANT}
        self._get_badge_request: GetBadgeRequest = get_badge_request

    def badge_id(self, badge_id: str) -> "GetBadgeRequestBuilder":
        self._get_badge_request.badge_id = badge_id
        self._get_badge_request.paths["badge_id"] = str(badge_id)
        return self

    def build(self) -> GetBadgeRequest:
        return self._get_badge_request
