# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListBadgeGrantRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.name: Optional[str] = None
        self.badge_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListBadgeGrantRequestBuilder":
        return ListBadgeGrantRequestBuilder()


class ListBadgeGrantRequestBuilder(object):

    def __init__(self) -> None:
        list_badge_grant_request = ListBadgeGrantRequest()
        list_badge_grant_request.http_method = HttpMethod.GET
        list_badge_grant_request.uri = "/open-apis/admin/v1/badges/:badge_id/grants"
        list_badge_grant_request.token_types = {AccessTokenType.TENANT}
        self._list_badge_grant_request: ListBadgeGrantRequest = list_badge_grant_request

    def page_size(self, page_size: int) -> "ListBadgeGrantRequestBuilder":
        self._list_badge_grant_request.page_size = page_size
        self._list_badge_grant_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListBadgeGrantRequestBuilder":
        self._list_badge_grant_request.page_token = page_token
        self._list_badge_grant_request.add_query("page_token", page_token)
        return self

    def user_id_type(self, user_id_type: str) -> "ListBadgeGrantRequestBuilder":
        self._list_badge_grant_request.user_id_type = user_id_type
        self._list_badge_grant_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "ListBadgeGrantRequestBuilder":
        self._list_badge_grant_request.department_id_type = department_id_type
        self._list_badge_grant_request.add_query("department_id_type", department_id_type)
        return self

    def name(self, name: str) -> "ListBadgeGrantRequestBuilder":
        self._list_badge_grant_request.name = name
        self._list_badge_grant_request.add_query("name", name)
        return self

    def badge_id(self, badge_id: str) -> "ListBadgeGrantRequestBuilder":
        self._list_badge_grant_request.badge_id = badge_id
        self._list_badge_grant_request.paths["badge_id"] = str(badge_id)
        return self

    def build(self) -> ListBadgeGrantRequest:
        return self._list_badge_grant_request
