# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .badge import Badge


class ListBadgeResponseBody(object):
    _types = {
        "badges": List[Badge],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.badges: Optional[List[Badge]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListBadgeResponseBodyBuilder":
        return ListBadgeResponseBodyBuilder()


class ListBadgeResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_badge_response_body = ListBadgeResponseBody()

    def badges(self, badges: List[Badge]) -> "ListBadgeResponseBodyBuilder":
        self._list_badge_response_body.badges = badges
        return self

    def page_token(self, page_token: str) -> "ListBadgeResponseBodyBuilder":
        self._list_badge_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListBadgeResponseBodyBuilder":
        self._list_badge_response_body.has_more = has_more
        return self

    def build(self) -> "ListBadgeResponseBody":
        return self._list_badge_response_body
