# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .reset_password_request_body import ResetPasswordRequestBody


class ResetPasswordRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[ResetPasswordRequestBody] = None

    @staticmethod
    def builder() -> "ResetPasswordRequestBuilder":
        return ResetPasswordRequestBuilder()


class ResetPasswordRequestBuilder(object):

    def __init__(self) -> None:
        reset_password_request = ResetPasswordRequest()
        reset_password_request.http_method = HttpMethod.POST
        reset_password_request.uri = "/open-apis/admin/v1/password/reset"
        reset_password_request.token_types = {AccessTokenType.TENANT}
        self._reset_password_request: ResetPasswordRequest = reset_password_request

    def user_id_type(self, user_id_type: str) -> "ResetPasswordRequestBuilder":
        self._reset_password_request.user_id_type = user_id_type
        self._reset_password_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: ResetPasswordRequestBody) -> "ResetPasswordRequestBuilder":
        self._reset_password_request.request_body = request_body
        self._reset_password_request.body = request_body
        return self

    def build(self) -> ResetPasswordRequest:
        return self._reset_password_request
