# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class SplashPageStat(object):
    _types = {
        "date": str,
        "splash_id": str,
        "impression_count": int,
        "click_count": int,
        "skip_count": int,
        "impression_count_accumulate": int,
        "click_count_accumulate": int,
        "skip_count_accumulate": int,
    }

    def __init__(self, d=None):
        self.date: Optional[str] = None
        self.splash_id: Optional[str] = None
        self.impression_count: Optional[int] = None
        self.click_count: Optional[int] = None
        self.skip_count: Optional[int] = None
        self.impression_count_accumulate: Optional[int] = None
        self.click_count_accumulate: Optional[int] = None
        self.skip_count_accumulate: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SplashPageStatBuilder":
        return SplashPageStatBuilder()


class SplashPageStatBuilder(object):
    def __init__(self) -> None:
        self._splash_page_stat = SplashPageStat()

    def date(self, date: str) -> "SplashPageStatBuilder":
        self._splash_page_stat.date = date
        return self

    def splash_id(self, splash_id: str) -> "SplashPageStatBuilder":
        self._splash_page_stat.splash_id = splash_id
        return self

    def impression_count(self, impression_count: int) -> "SplashPageStatBuilder":
        self._splash_page_stat.impression_count = impression_count
        return self

    def click_count(self, click_count: int) -> "SplashPageStatBuilder":
        self._splash_page_stat.click_count = click_count
        return self

    def skip_count(self, skip_count: int) -> "SplashPageStatBuilder":
        self._splash_page_stat.skip_count = skip_count
        return self

    def impression_count_accumulate(self, impression_count_accumulate: int) -> "SplashPageStatBuilder":
        self._splash_page_stat.impression_count_accumulate = impression_count_accumulate
        return self

    def click_count_accumulate(self, click_count_accumulate: int) -> "SplashPageStatBuilder":
        self._splash_page_stat.click_count_accumulate = click_count_accumulate
        return self

    def skip_count_accumulate(self, skip_count_accumulate: int) -> "SplashPageStatBuilder":
        self._splash_page_stat.skip_count_accumulate = skip_count_accumulate
        return self

    def build(self) -> "SplashPageStat":
        return self._splash_page_stat
