# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .badge import Badge


class UpdateBadgeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.badge_id: Optional[str] = None
        self.request_body: Optional[Badge] = None

    @staticmethod
    def builder() -> "UpdateBadgeRequestBuilder":
        return UpdateBadgeRequestBuilder()


class UpdateBadgeRequestBuilder(object):

    def __init__(self) -> None:
        update_badge_request = UpdateBadgeRequest()
        update_badge_request.http_method = HttpMethod.PUT
        update_badge_request.uri = "/open-apis/admin/v1/badges/:badge_id"
        update_badge_request.token_types = {AccessTokenType.TENANT}
        self._update_badge_request: UpdateBadgeRequest = update_badge_request

    def badge_id(self, badge_id: str) -> "UpdateBadgeRequestBuilder":
        self._update_badge_request.badge_id = badge_id
        self._update_badge_request.paths["badge_id"] = str(badge_id)
        return self

    def request_body(self, request_body: Badge) -> "UpdateBadgeRequestBuilder":
        self._update_badge_request.request_body = request_body
        self._update_badge_request.body = request_body
        return self

    def build(self) -> UpdateBadgeRequest:
        return self._update_badge_request
