# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_badge_request import CreateBadgeRequest
from ..model.create_badge_response import CreateBadgeResponse
from ..model.get_badge_request import GetBadgeRequest
from ..model.get_badge_response import GetBadgeResponse
from ..model.list_badge_request import ListBadgeRequest
from ..model.list_badge_response import ListBadgeResponse
from ..model.update_badge_request import UpdateBadgeRequest
from ..model.update_badge_response import UpdateBadgeResponse


class Badge(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateBadgeRequest, option: Optional[RequestOption] = None) -> CreateBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateBadgeResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateBadgeRequest, option: Optional[RequestOption] = None) -> CreateBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateBadgeResponse)
        response.raw = resp

        return response

    def get(self, request: GetBadgeRequest, option: Optional[RequestOption] = None) -> GetBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), GetBadgeResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetBadgeRequest, option: Optional[RequestOption] = None) -> GetBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), GetBadgeResponse)
        response.raw = resp

        return response

    def list(self, request: ListBadgeRequest, option: Optional[RequestOption] = None) -> ListBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), ListBadgeResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListBadgeRequest, option: Optional[RequestOption] = None) -> ListBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), ListBadgeResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateBadgeRequest, option: Optional[RequestOption] = None) -> UpdateBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateBadgeResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateBadgeRequest, option: Optional[RequestOption] = None) -> UpdateBadgeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateBadgeResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateBadgeResponse)
        response.raw = resp

        return response
