# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class AppConfigEvent(object):
    _types = {
        "subscription_type": str,
        "request_url": str,
        "add_events": List[str],
        "remove_events": List[str],
    }

    def __init__(self, d=None):
        self.subscription_type: Optional[str] = None
        self.request_url: Optional[str] = None
        self.add_events: Optional[List[str]] = None
        self.remove_events: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppConfigEventBuilder":
        return AppConfigEventBuilder()


class AppConfigEventBuilder(object):
    def __init__(self) -> None:
        self._app_config_event = AppConfigEvent()

    def subscription_type(self, subscription_type: str) -> "AppConfigEventBuilder":
        self._app_config_event.subscription_type = subscription_type
        return self

    def request_url(self, request_url: str) -> "AppConfigEventBuilder":
        self._app_config_event.request_url = request_url
        return self

    def add_events(self, add_events: List[str]) -> "AppConfigEventBuilder":
        self._app_config_event.add_events = add_events
        return self

    def remove_events(self, remove_events: List[str]) -> "AppConfigEventBuilder":
        self._app_config_event.remove_events = remove_events
        return self

    def build(self) -> "AppConfigEvent":
        return self._app_config_event
