# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_config_scope_item import AppConfigScopeItem


class AppConfigScope(object):
    _types = {
        "add_scopes": List[AppConfigScopeItem],
        "remove_scopes": List[AppConfigScopeItem],
    }

    def __init__(self, d=None):
        self.add_scopes: Optional[List[AppConfigScopeItem]] = None
        self.remove_scopes: Optional[List[AppConfigScopeItem]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppConfigScopeBuilder":
        return AppConfigScopeBuilder()


class AppConfigScopeBuilder(object):
    def __init__(self) -> None:
        self._app_config_scope = AppConfigScope()

    def add_scopes(self, add_scopes: List[AppConfigScopeItem]) -> "AppConfigScopeBuilder":
        self._app_config_scope.add_scopes = add_scopes
        return self

    def remove_scopes(self, remove_scopes: List[AppConfigScopeItem]) -> "AppConfigScopeBuilder":
        self._app_config_scope.remove_scopes = remove_scopes
        return self

    def build(self) -> "AppConfigScope":
        return self._app_config_scope
