# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class AppConfigSecurityItem(object):
    _types = {
        "redirect_urls": List[str],
        "allowed_ips": List[str],
        "h5_trusted_domains": List[str],
        "web_view_trusted_domains": List[str],
        "allowed_schemas": List[str],
        "allowed_server_domains": List[str],
    }

    def __init__(self, d=None):
        self.redirect_urls: Optional[List[str]] = None
        self.allowed_ips: Optional[List[str]] = None
        self.h5_trusted_domains: Optional[List[str]] = None
        self.web_view_trusted_domains: Optional[List[str]] = None
        self.allowed_schemas: Optional[List[str]] = None
        self.allowed_server_domains: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppConfigSecurityItemBuilder":
        return AppConfigSecurityItemBuilder()


class AppConfigSecurityItemBuilder(object):
    def __init__(self) -> None:
        self._app_config_security_item = AppConfigSecurityItem()

    def redirect_urls(self, redirect_urls: List[str]) -> "AppConfigSecurityItemBuilder":
        self._app_config_security_item.redirect_urls = redirect_urls
        return self

    def allowed_ips(self, allowed_ips: List[str]) -> "AppConfigSecurityItemBuilder":
        self._app_config_security_item.allowed_ips = allowed_ips
        return self

    def h5_trusted_domains(self, h5_trusted_domains: List[str]) -> "AppConfigSecurityItemBuilder":
        self._app_config_security_item.h5_trusted_domains = h5_trusted_domains
        return self

    def web_view_trusted_domains(self, web_view_trusted_domains: List[str]) -> "AppConfigSecurityItemBuilder":
        self._app_config_security_item.web_view_trusted_domains = web_view_trusted_domains
        return self

    def allowed_schemas(self, allowed_schemas: List[str]) -> "AppConfigSecurityItemBuilder":
        self._app_config_security_item.allowed_schemas = allowed_schemas
        return self

    def allowed_server_domains(self, allowed_server_domains: List[str]) -> "AppConfigSecurityItemBuilder":
        self._app_config_security_item.allowed_server_domains = allowed_server_domains
        return self

    def build(self) -> "AppConfigSecurityItem":
        return self._app_config_security_item
