# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .app_visibility_id_list import AppVisibilityIdList


class AppConfigVisibility(object):
    _types = {
        "is_visible_to_all": bool,
        "visible_list": AppVisibilityIdList,
    }

    def __init__(self, d=None):
        self.is_visible_to_all: Optional[bool] = None
        self.visible_list: Optional[AppVisibilityIdList] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppConfigVisibilityBuilder":
        return AppConfigVisibilityBuilder()


class AppConfigVisibilityBuilder(object):
    def __init__(self) -> None:
        self._app_config_visibility = AppConfigVisibility()

    def is_visible_to_all(self, is_visible_to_all: bool) -> "AppConfigVisibilityBuilder":
        self._app_config_visibility.is_visible_to_all = is_visible_to_all
        return self

    def visible_list(self, visible_list: AppVisibilityIdList) -> "AppConfigVisibilityBuilder":
        self._app_config_visibility.visible_list = visible_list
        return self

    def build(self) -> "AppConfigVisibility":
        return self._app_config_visibility
