# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AppVersionId(object):
    _types = {
        "version": str,
        "version_id": str,
    }

    def __init__(self, d=None):
        self.version: Optional[str] = None
        self.version_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppVersionIdBuilder":
        return AppVersionIdBuilder()


class AppVersionIdBuilder(object):
    def __init__(self) -> None:
        self._app_version_id = AppVersionId()

    def version(self, version: str) -> "AppVersionIdBuilder":
        self._app_version_id.version = version
        return self

    def version_id(self, version_id: str) -> "AppVersionIdBuilder":
        self._app_version_id.version_id = version_id
        return self

    def build(self) -> "AppVersionId":
        return self._app_version_id
