# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .app_visible_list_event import AppVisibleListEvent


class AppVisibilityEvent(object):
    _types = {
        "is_all": bool,
        "visible_list": AppVisibleListEvent,
        "invisible_list": AppVisibleListEvent,
    }

    def __init__(self, d=None):
        self.is_all: Optional[bool] = None
        self.visible_list: Optional[AppVisibleListEvent] = None
        self.invisible_list: Optional[AppVisibleListEvent] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppVisibilityEventBuilder":
        return AppVisibilityEventBuilder()


class AppVisibilityEventBuilder(object):
    def __init__(self) -> None:
        self._app_visibility_event = AppVisibilityEvent()

    def is_all(self, is_all: bool) -> "AppVisibilityEventBuilder":
        self._app_visibility_event.is_all = is_all
        return self

    def visible_list(self, visible_list: AppVisibleListEvent) -> "AppVisibilityEventBuilder":
        self._app_visibility_event.visible_list = visible_list
        return self

    def invisible_list(self, invisible_list: AppVisibleListEvent) -> "AppVisibilityEventBuilder":
        self._app_visibility_event.invisible_list = invisible_list
        return self

    def build(self) -> "AppVisibilityEvent":
        return self._app_visibility_event
