# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AppVisibilityItem(object):
    _types = {
        "user_id": str,
        "department_id": str,
        "group_id": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.department_id: Optional[str] = None
        self.group_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppVisibilityItemBuilder":
        return AppVisibilityItemBuilder()


class AppVisibilityItemBuilder(object):
    def __init__(self) -> None:
        self._app_visibility_item = AppVisibilityItem()

    def user_id(self, user_id: str) -> "AppVisibilityItemBuilder":
        self._app_visibility_item.user_id = user_id
        return self

    def department_id(self, department_id: str) -> "AppVisibilityItemBuilder":
        self._app_visibility_item.department_id = department_id
        return self

    def group_id(self, group_id: str) -> "AppVisibilityItemBuilder":
        self._app_visibility_item.group_id = group_id
        return self

    def build(self) -> "AppVisibilityItem":
        return self._app_visibility_item
