# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .user_id import UserId


class AppVisibleListEvent(object):
    _types = {
        "open_ids": List[UserId],
        "department_ids": List[str],
    }

    def __init__(self, d=None):
        self.open_ids: Optional[List[UserId]] = None
        self.department_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppVisibleListEventBuilder":
        return AppVisibleListEventBuilder()


class AppVisibleListEventBuilder(object):
    def __init__(self) -> None:
        self._app_visible_list_event = AppVisibleListEvent()

    def open_ids(self, open_ids: List[UserId]) -> "AppVisibleListEventBuilder":
        self._app_visible_list_event.open_ids = open_ids
        return self

    def department_ids(self, department_ids: List[str]) -> "AppVisibleListEventBuilder":
        self._app_visible_list_event.department_ids = department_ids
        return self

    def build(self) -> "AppVisibleListEvent":
        return self._app_visible_list_event
