# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_i18n_info import AppI18nInfo
from .app_scope import AppScope
from .application_owner import ApplicationOwner


class Application(object):
    _types = {
        "app_id": str,
        "creator_id": int,
        "status": int,
        "scene_type": int,
        "payment_type": int,
        "create_source": str,
        "redirect_urls": List[str],
        "online_version_id": int,
        "unaudit_version_id": int,
        "app_name": str,
        "avatar_url": str,
        "description": str,
        "scopes": List[AppScope],
        "back_home_url": str,
        "i18n": List[AppI18nInfo],
        "primary_language": str,
        "common_categories": List[str],
        "owner": ApplicationOwner,
    }

    def __init__(self, d=None):
        self.app_id: Optional[str] = None
        self.creator_id: Optional[int] = None
        self.status: Optional[int] = None
        self.scene_type: Optional[int] = None
        self.payment_type: Optional[int] = None
        self.create_source: Optional[str] = None
        self.redirect_urls: Optional[List[str]] = None
        self.online_version_id: Optional[int] = None
        self.unaudit_version_id: Optional[int] = None
        self.app_name: Optional[str] = None
        self.avatar_url: Optional[str] = None
        self.description: Optional[str] = None
        self.scopes: Optional[List[AppScope]] = None
        self.back_home_url: Optional[str] = None
        self.i18n: Optional[List[AppI18nInfo]] = None
        self.primary_language: Optional[str] = None
        self.common_categories: Optional[List[str]] = None
        self.owner: Optional[ApplicationOwner] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationBuilder":
        return ApplicationBuilder()


class ApplicationBuilder(object):
    def __init__(self) -> None:
        self._application = Application()

    def app_id(self, app_id: str) -> "ApplicationBuilder":
        self._application.app_id = app_id
        return self

    def creator_id(self, creator_id: int) -> "ApplicationBuilder":
        self._application.creator_id = creator_id
        return self

    def status(self, status: int) -> "ApplicationBuilder":
        self._application.status = status
        return self

    def scene_type(self, scene_type: int) -> "ApplicationBuilder":
        self._application.scene_type = scene_type
        return self

    def payment_type(self, payment_type: int) -> "ApplicationBuilder":
        self._application.payment_type = payment_type
        return self

    def create_source(self, create_source: str) -> "ApplicationBuilder":
        self._application.create_source = create_source
        return self

    def redirect_urls(self, redirect_urls: List[str]) -> "ApplicationBuilder":
        self._application.redirect_urls = redirect_urls
        return self

    def online_version_id(self, online_version_id: int) -> "ApplicationBuilder":
        self._application.online_version_id = online_version_id
        return self

    def unaudit_version_id(self, unaudit_version_id: int) -> "ApplicationBuilder":
        self._application.unaudit_version_id = unaudit_version_id
        return self

    def app_name(self, app_name: str) -> "ApplicationBuilder":
        self._application.app_name = app_name
        return self

    def avatar_url(self, avatar_url: str) -> "ApplicationBuilder":
        self._application.avatar_url = avatar_url
        return self

    def description(self, description: str) -> "ApplicationBuilder":
        self._application.description = description
        return self

    def scopes(self, scopes: List[AppScope]) -> "ApplicationBuilder":
        self._application.scopes = scopes
        return self

    def back_home_url(self, back_home_url: str) -> "ApplicationBuilder":
        self._application.back_home_url = back_home_url
        return self

    def i18n(self, i18n: List[AppI18nInfo]) -> "ApplicationBuilder":
        self._application.i18n = i18n
        return self

    def primary_language(self, primary_language: str) -> "ApplicationBuilder":
        self._application.primary_language = primary_language
        return self

    def common_categories(self, common_categories: List[str]) -> "ApplicationBuilder":
        self._application.common_categories = common_categories
        return self

    def owner(self, owner: ApplicationOwner) -> "ApplicationBuilder":
        self._application.owner = owner
        return self

    def build(self) -> "Application":
        return self._application
