# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_ability import AppAbility
from .app_i18n_info import AppI18nInfo
from .app_scope import AppScope
from .app_version_remark import AppVersionRemark


class ApplicationAppVersion(object):
    _types = {
        "app_id": str,
        "version": str,
        "version_id": int,
        "app_name": str,
        "avatar_url": str,
        "description": str,
        "scopes": List[AppScope],
        "back_home_url": str,
        "i18n": List[AppI18nInfo],
        "common_categories": List[str],
        "events": List[str],
        "status": int,
        "create_time": int,
        "publish_time": int,
        "ability": AppAbility,
        "remark": AppVersionRemark,
    }

    def __init__(self, d=None):
        self.app_id: Optional[str] = None
        self.version: Optional[str] = None
        self.version_id: Optional[int] = None
        self.app_name: Optional[str] = None
        self.avatar_url: Optional[str] = None
        self.description: Optional[str] = None
        self.scopes: Optional[List[AppScope]] = None
        self.back_home_url: Optional[str] = None
        self.i18n: Optional[List[AppI18nInfo]] = None
        self.common_categories: Optional[List[str]] = None
        self.events: Optional[List[str]] = None
        self.status: Optional[int] = None
        self.create_time: Optional[int] = None
        self.publish_time: Optional[int] = None
        self.ability: Optional[AppAbility] = None
        self.remark: Optional[AppVersionRemark] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationAppVersionBuilder":
        return ApplicationAppVersionBuilder()


class ApplicationAppVersionBuilder(object):
    def __init__(self) -> None:
        self._application_app_version = ApplicationAppVersion()

    def app_id(self, app_id: str) -> "ApplicationAppVersionBuilder":
        self._application_app_version.app_id = app_id
        return self

    def version(self, version: str) -> "ApplicationAppVersionBuilder":
        self._application_app_version.version = version
        return self

    def version_id(self, version_id: int) -> "ApplicationAppVersionBuilder":
        self._application_app_version.version_id = version_id
        return self

    def app_name(self, app_name: str) -> "ApplicationAppVersionBuilder":
        self._application_app_version.app_name = app_name
        return self

    def avatar_url(self, avatar_url: str) -> "ApplicationAppVersionBuilder":
        self._application_app_version.avatar_url = avatar_url
        return self

    def description(self, description: str) -> "ApplicationAppVersionBuilder":
        self._application_app_version.description = description
        return self

    def scopes(self, scopes: List[AppScope]) -> "ApplicationAppVersionBuilder":
        self._application_app_version.scopes = scopes
        return self

    def back_home_url(self, back_home_url: str) -> "ApplicationAppVersionBuilder":
        self._application_app_version.back_home_url = back_home_url
        return self

    def i18n(self, i18n: List[AppI18nInfo]) -> "ApplicationAppVersionBuilder":
        self._application_app_version.i18n = i18n
        return self

    def common_categories(self, common_categories: List[str]) -> "ApplicationAppVersionBuilder":
        self._application_app_version.common_categories = common_categories
        return self

    def events(self, events: List[str]) -> "ApplicationAppVersionBuilder":
        self._application_app_version.events = events
        return self

    def status(self, status: int) -> "ApplicationAppVersionBuilder":
        self._application_app_version.status = status
        return self

    def create_time(self, create_time: int) -> "ApplicationAppVersionBuilder":
        self._application_app_version.create_time = create_time
        return self

    def publish_time(self, publish_time: int) -> "ApplicationAppVersionBuilder":
        self._application_app_version.publish_time = publish_time
        return self

    def ability(self, ability: AppAbility) -> "ApplicationAppVersionBuilder":
        self._application_app_version.ability = ability
        return self

    def remark(self, remark: AppVersionRemark) -> "ApplicationAppVersionBuilder":
        self._application_app_version.remark = remark
        return self

    def build(self) -> "ApplicationAppVersion":
        return self._application_app_version
