# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class ApplicationFeedback(object):
    _types = {
        "feedback_id": int,
        "app_id": str,
        "feedback_time": str,
        "tenant_name": str,
        "feedback_type": int,
        "status": int,
        "fault_type": List[int],
        "fault_time": str,
        "source": int,
        "contact": str,
        "update_time": str,
        "description": str,
        "user_id": str,
        "operator_id": str,
        "images": List[str],
        "feedback_path": str,
    }

    def __init__(self, d=None):
        self.feedback_id: Optional[int] = None
        self.app_id: Optional[str] = None
        self.feedback_time: Optional[str] = None
        self.tenant_name: Optional[str] = None
        self.feedback_type: Optional[int] = None
        self.status: Optional[int] = None
        self.fault_type: Optional[List[int]] = None
        self.fault_time: Optional[str] = None
        self.source: Optional[int] = None
        self.contact: Optional[str] = None
        self.update_time: Optional[str] = None
        self.description: Optional[str] = None
        self.user_id: Optional[str] = None
        self.operator_id: Optional[str] = None
        self.images: Optional[List[str]] = None
        self.feedback_path: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationFeedbackBuilder":
        return ApplicationFeedbackBuilder()


class ApplicationFeedbackBuilder(object):
    def __init__(self) -> None:
        self._application_feedback = ApplicationFeedback()

    def feedback_id(self, feedback_id: int) -> "ApplicationFeedbackBuilder":
        self._application_feedback.feedback_id = feedback_id
        return self

    def app_id(self, app_id: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.app_id = app_id
        return self

    def feedback_time(self, feedback_time: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.feedback_time = feedback_time
        return self

    def tenant_name(self, tenant_name: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.tenant_name = tenant_name
        return self

    def feedback_type(self, feedback_type: int) -> "ApplicationFeedbackBuilder":
        self._application_feedback.feedback_type = feedback_type
        return self

    def status(self, status: int) -> "ApplicationFeedbackBuilder":
        self._application_feedback.status = status
        return self

    def fault_type(self, fault_type: List[int]) -> "ApplicationFeedbackBuilder":
        self._application_feedback.fault_type = fault_type
        return self

    def fault_time(self, fault_time: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.fault_time = fault_time
        return self

    def source(self, source: int) -> "ApplicationFeedbackBuilder":
        self._application_feedback.source = source
        return self

    def contact(self, contact: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.contact = contact
        return self

    def update_time(self, update_time: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.update_time = update_time
        return self

    def description(self, description: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.description = description
        return self

    def user_id(self, user_id: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.user_id = user_id
        return self

    def operator_id(self, operator_id: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.operator_id = operator_id
        return self

    def images(self, images: List[str]) -> "ApplicationFeedbackBuilder":
        self._application_feedback.images = images
        return self

    def feedback_path(self, feedback_path: str) -> "ApplicationFeedbackBuilder":
        self._application_feedback.feedback_path = feedback_path
        return self

    def build(self) -> "ApplicationFeedback":
        return self._application_feedback
