# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ApplicationOwner(object):
    _types = {
        "type": int,
        "owner_id": str,
        "name": str,
        "help_desk": str,
        "email": str,
        "phone": str,
    }

    def __init__(self, d=None):
        self.type: Optional[int] = None
        self.owner_id: Optional[str] = None
        self.name: Optional[str] = None
        self.help_desk: Optional[str] = None
        self.email: Optional[str] = None
        self.phone: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationOwnerBuilder":
        return ApplicationOwnerBuilder()


class ApplicationOwnerBuilder(object):
    def __init__(self) -> None:
        self._application_owner = ApplicationOwner()

    def type(self, type: int) -> "ApplicationOwnerBuilder":
        self._application_owner.type = type
        return self

    def owner_id(self, owner_id: str) -> "ApplicationOwnerBuilder":
        self._application_owner.owner_id = owner_id
        return self

    def name(self, name: str) -> "ApplicationOwnerBuilder":
        self._application_owner.name = name
        return self

    def help_desk(self, help_desk: str) -> "ApplicationOwnerBuilder":
        self._application_owner.help_desk = help_desk
        return self

    def email(self, email: str) -> "ApplicationOwnerBuilder":
        self._application_owner.email = email
        return self

    def phone(self, phone: str) -> "ApplicationOwnerBuilder":
        self._application_owner.phone = phone
        return self

    def build(self) -> "ApplicationOwner":
        return self._application_owner
