# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .app_visible_list import AppVisibleList


class ApplicationVisibility(object):
    _types = {
        "is_all": bool,
        "visible_list": AppVisibleList,
        "invisible_list": AppVisibleList,
    }

    def __init__(self, d=None):
        self.is_all: Optional[bool] = None
        self.visible_list: Optional[AppVisibleList] = None
        self.invisible_list: Optional[AppVisibleList] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationVisibilityBuilder":
        return ApplicationVisibilityBuilder()


class ApplicationVisibilityBuilder(object):
    def __init__(self) -> None:
        self._application_visibility = ApplicationVisibility()

    def is_all(self, is_all: bool) -> "ApplicationVisibilityBuilder":
        self._application_visibility.is_all = is_all
        return self

    def visible_list(self, visible_list: AppVisibleList) -> "ApplicationVisibilityBuilder":
        self._application_visibility.visible_list = visible_list
        return self

    def invisible_list(self, invisible_list: AppVisibleList) -> "ApplicationVisibilityBuilder":
        self._application_visibility.invisible_list = invisible_list
        return self

    def build(self) -> "ApplicationVisibility":
        return self._application_visibility
