# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .block_i18n_info import BlockI18nInfo


class Block(object):
    _types = {
        "block_type_id": str,
        "version_id": str,
        "i18n": List[BlockI18nInfo],
        "mobile_icon_url": str,
        "pc_icon_url": str,
    }

    def __init__(self, d=None):
        self.block_type_id: Optional[str] = None
        self.version_id: Optional[str] = None
        self.i18n: Optional[List[BlockI18nInfo]] = None
        self.mobile_icon_url: Optional[str] = None
        self.pc_icon_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BlockBuilder":
        return BlockBuilder()


class BlockBuilder(object):
    def __init__(self) -> None:
        self._block = Block()

    def block_type_id(self, block_type_id: str) -> "BlockBuilder":
        self._block.block_type_id = block_type_id
        return self

    def version_id(self, version_id: str) -> "BlockBuilder":
        self._block.version_id = version_id
        return self

    def i18n(self, i18n: List[BlockI18nInfo]) -> "BlockBuilder":
        self._block.i18n = i18n
        return self

    def mobile_icon_url(self, mobile_icon_url: str) -> "BlockBuilder":
        self._block.mobile_icon_url = mobile_icon_url
        return self

    def pc_icon_url(self, pc_icon_url: str) -> "BlockBuilder":
        self._block.pc_icon_url = pc_icon_url
        return self

    def build(self) -> "Block":
        return self._block
