# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .cloud_doc_i18n_info import CloudDocI18nInfo


class CloudDoc(object):
    _types = {
        "space_url": str,
        "i18n": List[CloudDocI18nInfo],
        "icon_url": str,
        "mode": int,
    }

    def __init__(self, d=None):
        self.space_url: Optional[str] = None
        self.i18n: Optional[List[CloudDocI18nInfo]] = None
        self.icon_url: Optional[str] = None
        self.mode: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CloudDocBuilder":
        return CloudDocBuilder()


class CloudDocBuilder(object):
    def __init__(self) -> None:
        self._cloud_doc = CloudDoc()

    def space_url(self, space_url: str) -> "CloudDocBuilder":
        self._cloud_doc.space_url = space_url
        return self

    def i18n(self, i18n: List[CloudDocI18nInfo]) -> "CloudDocBuilder":
        self._cloud_doc.i18n = i18n
        return self

    def icon_url(self, icon_url: str) -> "CloudDocBuilder":
        self._cloud_doc.icon_url = icon_url
        return self

    def mode(self, mode: int) -> "CloudDocBuilder":
        self._cloud_doc.mode = mode
        return self

    def build(self) -> "CloudDoc":
        return self._cloud_doc
