# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ContactsRangeSuggestApplicationAppVersionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.department_id_type: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.app_id: Optional[str] = None
        self.version_id: Optional[int] = None

    @staticmethod
    def builder() -> "ContactsRangeSuggestApplicationAppVersionRequestBuilder":
        return ContactsRangeSuggestApplicationAppVersionRequestBuilder()


class ContactsRangeSuggestApplicationAppVersionRequestBuilder(object):

    def __init__(self) -> None:
        contacts_range_suggest_application_app_version_request = ContactsRangeSuggestApplicationAppVersionRequest()
        contacts_range_suggest_application_app_version_request.http_method = HttpMethod.GET
        contacts_range_suggest_application_app_version_request.uri = "/open-apis/application/v6/applications/:app_id/app_versions/:version_id/contacts_range_suggest"
        contacts_range_suggest_application_app_version_request.token_types = {AccessTokenType.TENANT}
        self._contacts_range_suggest_application_app_version_request: ContactsRangeSuggestApplicationAppVersionRequest = contacts_range_suggest_application_app_version_request

    def department_id_type(self, department_id_type: str) -> "ContactsRangeSuggestApplicationAppVersionRequestBuilder":
        self._contacts_range_suggest_application_app_version_request.department_id_type = department_id_type
        self._contacts_range_suggest_application_app_version_request.add_query("department_id_type", department_id_type)
        return self

    def user_id_type(self, user_id_type: str) -> "ContactsRangeSuggestApplicationAppVersionRequestBuilder":
        self._contacts_range_suggest_application_app_version_request.user_id_type = user_id_type
        self._contacts_range_suggest_application_app_version_request.add_query("user_id_type", user_id_type)
        return self

    def app_id(self, app_id: str) -> "ContactsRangeSuggestApplicationAppVersionRequestBuilder":
        self._contacts_range_suggest_application_app_version_request.app_id = app_id
        self._contacts_range_suggest_application_app_version_request.paths["app_id"] = str(app_id)
        return self

    def version_id(self, version_id: int) -> "ContactsRangeSuggestApplicationAppVersionRequestBuilder":
        self._contacts_range_suggest_application_app_version_request.version_id = version_id
        self._contacts_range_suggest_application_app_version_request.paths["version_id"] = str(version_id)
        return self

    def build(self) -> ContactsRangeSuggestApplicationAppVersionRequest:
        return self._contacts_range_suggest_application_app_version_request
