# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class DepartmentOverviewApplicationAppUsageRequestBody(object):
    _types = {
        "date": str,
        "cycle_type": int,
        "department_id": str,
        "recursion": int,
        "page_size": int,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.date: Optional[str] = None
        self.cycle_type: Optional[int] = None
        self.department_id: Optional[str] = None
        self.recursion: Optional[int] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DepartmentOverviewApplicationAppUsageRequestBodyBuilder":
        return DepartmentOverviewApplicationAppUsageRequestBodyBuilder()


class DepartmentOverviewApplicationAppUsageRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._department_overview_application_app_usage_request_body = DepartmentOverviewApplicationAppUsageRequestBody()

    def date(self, date: str) -> "DepartmentOverviewApplicationAppUsageRequestBodyBuilder":
        self._department_overview_application_app_usage_request_body.date = date
        return self

    def cycle_type(self, cycle_type: int) -> "DepartmentOverviewApplicationAppUsageRequestBodyBuilder":
        self._department_overview_application_app_usage_request_body.cycle_type = cycle_type
        return self

    def department_id(self, department_id: str) -> "DepartmentOverviewApplicationAppUsageRequestBodyBuilder":
        self._department_overview_application_app_usage_request_body.department_id = department_id
        return self

    def recursion(self, recursion: int) -> "DepartmentOverviewApplicationAppUsageRequestBodyBuilder":
        self._department_overview_application_app_usage_request_body.recursion = recursion
        return self

    def page_size(self, page_size: int) -> "DepartmentOverviewApplicationAppUsageRequestBodyBuilder":
        self._department_overview_application_app_usage_request_body.page_size = page_size
        return self

    def page_token(self, page_token: str) -> "DepartmentOverviewApplicationAppUsageRequestBodyBuilder":
        self._department_overview_application_app_usage_request_body.page_token = page_token
        return self

    def build(self) -> "DepartmentOverviewApplicationAppUsageRequestBody":
        return self._department_overview_application_app_usage_request_body
