# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetApplicationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.lang: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.app_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetApplicationRequestBuilder":
        return GetApplicationRequestBuilder()


class GetApplicationRequestBuilder(object):

    def __init__(self) -> None:
        get_application_request = GetApplicationRequest()
        get_application_request.http_method = HttpMethod.GET
        get_application_request.uri = "/open-apis/application/v6/applications/:app_id"
        get_application_request.token_types = {AccessTokenType.TENANT}
        self._get_application_request: GetApplicationRequest = get_application_request

    def lang(self, lang: str) -> "GetApplicationRequestBuilder":
        self._get_application_request.lang = lang
        self._get_application_request.add_query("lang", lang)
        return self

    def user_id_type(self, user_id_type: str) -> "GetApplicationRequestBuilder":
        self._get_application_request.user_id_type = user_id_type
        self._get_application_request.add_query("user_id_type", user_id_type)
        return self

    def app_id(self, app_id: str) -> "GetApplicationRequestBuilder":
        self._get_application_request.app_id = app_id
        self._get_application_request.paths["app_id"] = str(app_id)
        return self

    def build(self) -> GetApplicationRequest:
        return self._get_application_request
