# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .message_action_i18n_info import MessageActionI18nInfo


class MessageAction(object):
    _types = {
        "pc_app_link": str,
        "mobile_app_link": str,
        "i18n": List[MessageActionI18nInfo],
    }

    def __init__(self, d=None):
        self.pc_app_link: Optional[str] = None
        self.mobile_app_link: Optional[str] = None
        self.i18n: Optional[List[MessageActionI18nInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MessageActionBuilder":
        return MessageActionBuilder()


class MessageActionBuilder(object):
    def __init__(self) -> None:
        self._message_action = MessageAction()

    def pc_app_link(self, pc_app_link: str) -> "MessageActionBuilder":
        self._message_action.pc_app_link = pc_app_link
        return self

    def mobile_app_link(self, mobile_app_link: str) -> "MessageActionBuilder":
        self._message_action.mobile_app_link = mobile_app_link
        return self

    def i18n(self, i18n: List[MessageActionI18nInfo]) -> "MessageActionBuilder":
        self._message_action.i18n = i18n
        return self

    def build(self) -> "MessageAction":
        return self._message_action
