# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MessageOverviewItem(object):
    _types = {
        "page_view": int,
        "unique_visitor": int,
        "chat_type": str,
        "message_type": str,
        "event_type": str,
    }

    def __init__(self, d=None):
        self.page_view: Optional[int] = None
        self.unique_visitor: Optional[int] = None
        self.chat_type: Optional[str] = None
        self.message_type: Optional[str] = None
        self.event_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MessageOverviewItemBuilder":
        return MessageOverviewItemBuilder()


class MessageOverviewItemBuilder(object):
    def __init__(self) -> None:
        self._message_overview_item = MessageOverviewItem()

    def page_view(self, page_view: int) -> "MessageOverviewItemBuilder":
        self._message_overview_item.page_view = page_view
        return self

    def unique_visitor(self, unique_visitor: int) -> "MessageOverviewItemBuilder":
        self._message_overview_item.unique_visitor = unique_visitor
        return self

    def chat_type(self, chat_type: str) -> "MessageOverviewItemBuilder":
        self._message_overview_item.chat_type = chat_type
        return self

    def message_type(self, message_type: str) -> "MessageOverviewItemBuilder":
        self._message_overview_item.message_type = message_type
        return self

    def event_type(self, event_type: str) -> "MessageOverviewItemBuilder":
        self._message_overview_item.event_type = event_type
        return self

    def build(self) -> "MessageOverviewItem":
        return self._message_overview_item
