# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .msg_action_i18n_info import MsgActionI18nInfo


class MsgAction(object):
    _types = {
        "pc_app_link": str,
        "mobile_app_link": str,
        "i18n": List[MsgActionI18nInfo],
    }

    def __init__(self, d=None):
        self.pc_app_link: Optional[str] = None
        self.mobile_app_link: Optional[str] = None
        self.i18n: Optional[List[MsgActionI18nInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MsgActionBuilder":
        return MsgActionBuilder()


class MsgActionBuilder(object):
    def __init__(self) -> None:
        self._msg_action = MsgAction()

    def pc_app_link(self, pc_app_link: str) -> "MsgActionBuilder":
        self._msg_action.pc_app_link = pc_app_link
        return self

    def mobile_app_link(self, mobile_app_link: str) -> "MsgActionBuilder":
        self._msg_action.mobile_app_link = mobile_app_link
        return self

    def i18n(self, i18n: List[MsgActionI18nInfo]) -> "MsgActionBuilder":
        self._msg_action.i18n = i18n
        return self

    def build(self) -> "MsgAction":
        return self._msg_action
