# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class NavigateMeta(object):
    _types = {
        "version": str,
        "image_url": str,
        "hover_image_url": str,
    }

    def __init__(self, d=None):
        self.version: Optional[str] = None
        self.image_url: Optional[str] = None
        self.hover_image_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "NavigateMetaBuilder":
        return NavigateMetaBuilder()


class NavigateMetaBuilder(object):
    def __init__(self) -> None:
        self._navigate_meta = NavigateMeta()

    def version(self, version: str) -> "NavigateMetaBuilder":
        self._navigate_meta.version = version
        return self

    def image_url(self, image_url: str) -> "NavigateMetaBuilder":
        self._navigate_meta.image_url = image_url
        return self

    def hover_image_url(self, hover_image_url: str) -> "NavigateMetaBuilder":
        self._navigate_meta.hover_image_url = hover_image_url
        return self

    def build(self) -> "NavigateMeta":
        return self._navigate_meta
